// Глобальные функции для управления прелоадером
	function showPreloader() {
		const preloader = document.getElementById('kkb-preloader');
		preloader.style.display = 'flex';
		preloader.style.opacity = 0;
		setTimeout(() => {
			preloader.style.opacity = 1;
		}, 50); // Плавное появление
	}

	function hidePreloader() {
		const preloader = document.getElementById('kkb-preloader');
		preloader.style.opacity = 0;
		setTimeout(() => {
			preloader.style.display = 'none';
		}, 300); // Плавное исчезновение
	}
	
	// Принимает строку и превращает все URL в кликабельные ссылки с классом kkb-hint-link

	function kkbAutoLinkify(text) {
		// Регекс на простые URL (не покрывает 100% случаев, но достаточно для ваших JSON)
		const urlPattern = /(https?:\/\/[^\s]+)/g;
		return text.replace(urlPattern, function(url) {
			// Текст ссылки оставляем как есть (URL) или можно тут заменить на свой текст
			return `<a class="kkb-hint-link" href="${url}" target="_blank" rel="noopener">${url}</a>`;
		});
	}

document.addEventListener('DOMContentLoaded', function() {
    // Получаем элементы кнопок
    const saveButton = document.querySelector('.kkb-save-design-settings-button');
    const resetButton = document.querySelector('.kkb-reset-design-settings-button');
	const buttonsSectionWrap = document.querySelector('.kkb-buttons-wrap');
	// Кнопка загрузки файла в переменной
	// const mediaUploaderButton = document.querySelector('.open-media-uploader-button');
	
	// Инициализируем медиазагрузчик один раз
    let mediaUploader;
	
	// Глобальная функция загрузки файлов в переменной
	document.addEventListener('click', function(event) {
		if (event.target.classList.contains('open-media-uploader-button')) {
			const button = event.target;
            const urlInput = button.closest('.value-url').querySelector('.url-input');
			
			// Проверяем, создан ли медиазагрузчик
            if (!mediaUploader) {
                mediaUploader = wp.media({
                    title: 'Загрузите или выберите изображение для иконки',
                    button: { text: 'Выбрать' },
                    multiple: false, // Не даём выбирать несколько файлов
                    library: { type: 'image' } // Ограничиваем выбор только изображениями
                });

				// Событие выбора файла
                mediaUploader.on('select', function() {
                    const attachment = mediaUploader.state().get('selection').first().toJSON();
                    if (mediaUploader.targetInput) {
                        mediaUploader.targetInput.value = attachment.url;

                        // Обновляем превью после выбора
                        updatePreviewImage(mediaUploader.targetInput);

                        // Убираем сохраненную ссылку на input после обновления
                        mediaUploader.targetInput = null;
                    }
                });
            }
			
			// Устанавливаем текущий input, связанный с кнопкой
            mediaUploader.targetInput = urlInput;

			// Открываем медиазагрузчик
            mediaUploader.open();
		}
	});
	
	// Создаем обёртку для кнопок
    // const buttonsAllWrap = document.createElement('div');
    // buttonsAllWrap.className = 'kkb-buttons-all-wrap';
    
    // Переносим кнопки в новый контейнер
    // buttonsSectionWrap.appendChild(buttonsAllWrap);
    // buttonsAllWrap.appendChild(saveButton);
    // buttonsAllWrap.appendChild(resetButton);
    
	// Получаем выпадающий список
    const designOptions = document.getElementById('design-options');
	
	// Получаем элемент для генерации переменных
	const mainVarWrap = document.querySelector('.var-section-wrap');
    
	// Управление видимостью общей обёртки обеих кнопок
    function toggleButtonsVisibility() {
        if (designOptions.value === "") {
            buttonsSectionWrap.style.display = 'none';
        } else {
            buttonsSectionWrap.style.display = 'flex';
        }
    }
	
    // Управление видимостью общей обёртки обеих кнопок
    // function toggleButtonsVisibility() {
        // if (designOptions.value === "") {
            // buttonsAllWrap.style.display = 'none';
        // } else {
            // buttonsAllWrap.style.display = 'flex';
        // }
    // }
	
    // Проверка видимости кнопок при загрузке страницы
    toggleButtonsVisibility();
	
	// Получаем элемент предупреждения
    const warningMessage = document.querySelector('.kkb-warning-css-missing-wrap');

    // Если опция не выбрана, скрываем предупреждение
    if (!designOptions.value) {
        warningMessage.style.display = 'none';
    }

	document.getElementById('design-options').addEventListener('change', function() {
		const selectedOption = this.value;

		// Обновляем видимость кнопок
		toggleButtonsVisibility();
		
		if (selectedOption) {	
			// Показать прелоадер
			showPreloader();
			
			// Скрываем сообщение об отсутствии связанного CSS по умолчанию
			warningMessage.style.display = 'none';
			
			// Проверяем наличие соответствующего CSS-файла
			const cssFilePath = window.kkbData.jsonUrl + selectedOption.replace('-vars', '') + '.css?timestamp=' + new Date().getTime();
			fetch(cssFilePath, { method: 'HEAD' })
				.then(response => {
					// Если CSS-файл не найден, показываем предупреждение
					// CSS-файл найден, скрываем предупреждение
                    warningMessage.style.display = response.ok ? 'none' : 'flex';
                });
				
			// Загружаем данные из соответствующего json-файла
			// fetch(window.kkbData.jsonUrl + selectedOption + '.json?timestamp=' + new Date().getTime())
			// fetch(window.kkbData.jsonUrl + selectedOption + '.json', { cache: 'reload' })
			fetch(window.kkbData.ajaxUrl + '?action=get_kkb_json&file=' + encodeURIComponent(selectedOption), {
    credentials: 'same-origin' // чтобы передавались куки, если нужно
})
			
				.then(response => {
    if (!response.ok) {
        throw new Error('Сервер вернул HTTP ' + response.status);
    }
    return response.json();
})
				// .then(response => response.json())

				.then(data => {
					mainVarWrap.innerHTML = ''; // Очищаем текущие данные
					
					// Создаём общий контейнер var-all-wrap
                    const allWrap = document.createElement('div');
                    allWrap.className = 'var-all-wrap';
					
					for (const key in data) {
						const variable = data[key];
						let inputField = '';
						let unit = variable.unit ? `<div class="unit">${variable.unit}</div>` : '';
						// let hint = variable.hint ? `<div class="hint">${variable.hint}</div>` : '';
						let hint = '';
						if (variable.hint) {
							// Сначала "линкуем" все URL
							const linked = kkbAutoLinkify(variable.hint);
							hint = `<div class="hint">${linked}</div>`;
						}
						
						let awesome = variable.awesome 
							? `<div class="awesome" data-before="${String.fromCharCode(parseInt(variable.value.replace('\\', ''), 16))}"></div>` 
							: '';

						let minmax = (variable.min || variable.max) 
							? `<div class="min-and-max">
								 ${variable.min ? `<div class="min">минимум: ${variable.min}</div>` : ''}
								 ${variable.max ? `<div class="max">максимум: ${variable.max}</div>` : ''}
							   </div>` 
							: '';
						
						let separator = variable.separator ? `<div class="separator"><div class="separator-title">${variable.separator}</div>${hint}</div>` : '';

						// Формируем поле ввода в зависимости от типа
						if (variable.type === 'text') {
							inputField = `
								<div class="var-row">
									<div class="label-and-hint">
										<div class="label">${variable.label}</div>
										
										<!-- описание -->
										${hint}
										
									</div>
									
									<div class="value-and-unit">
										
										<div class="value-text-and-awesome-wrap">
											<div class="value-text">
												<input type="text" value="${variable.value}" data-key="${key}">
											</div>
											
											<!-- иконка Awesome -->
											${awesome}
										</div>
										
									</div>
								</div>
								`;
						} else if (variable.type === 'number') {
							inputField = `
								<div class="var-row">
									<div class="label-and-hint">
										<div class="label">${variable.label}</div>
										
										<!-- описание -->
										${hint}
										
										<!-- минимум и максимум -->
										${minmax}
										
									</div>
									
									<div class="value-and-unit">
										
										<div class="value-number-and-unit-wrap">	
											<div class="value-number">
												<input type="number" value="${variable.value}" data-key="${key}" ${variable.min ? 'min="'+variable.min+'"' : ''} ${variable.max ? 'max="'+variable.max+'"' : ''} ${variable.step ? 'step="'+variable.step+'"' : ''}>
											</div>
											
											<!-- единица измерения -->
											${unit}
											
										</div>	
									</div>
								</div>
								`;
						} else if (variable.type === 'color') {
							inputField = `
								<div class="var-row">
									<div class="label-and-hint">
										<div class="label">${variable.label}</div>
										
										<!-- описание -->
										${hint}
										
									</div>

									<div class="value-and-unit">
										<div class="value-color">
											<div class="clr-field" style="color: ${variable.value};">
												<button type="button" aria-labelledby="clr-open-label"></button>
												<input type="text" class="color-field" value="${variable.value}" data-key="${key}">
											</div>
										</div>
									</div>
								</div>
								`;
						} else if (variable.type === 'url') {
							inputField = `
								<div class="var-row">
									<div class="label-and-hint">
										<div class="label">${variable.label}</div>
										
										<!-- описание -->
										${hint}
										
									</div>

									<div class="value-and-unit">
										<div class="value-url">
											<input type="text" value="${variable.value}" data-key="${key}" class="url-input">
											<button type="button" class="open-media-uploader-button">Выбрать</button>
										</div>
										
										<!-- Превью изображения -->
				
										<div class="preview-url-image">
										
											${variable.value ? `<img src="${variable.value}" alt="Превью изображения" onerror="this.style.display='none'; this.nextElementSibling.style.display='block';">` : ''}
											
											<div class="image-missing" style="display: ${variable.value ? 'none' : 'block'};">Упс, файл по этому адресу не найден</div>
											
										</div> 
										
									</div>
								</div>
								`;
						}

						const varWrap = document.createElement('div');
                        varWrap.className = 'var-wrap';
                        varWrap.innerHTML = `${inputField}${separator}`;
                        
                        // Добавляем var-wrap в общий контейнер
                        allWrap.appendChild(varWrap);
                    }

                    // Добавляем общий контейнер в var-section-wrap
                    mainVarWrap.appendChild(allWrap);
					// Скрыть прелоадер в случае ошибки
                    hidePreloader();
                })
				.catch(error => {
					console.error('Ошибка при загрузке данных:', error);
					alert('Ошибка загрузки данных.');
					// Скрыть прелоадер в случае ошибки
					hidePreloader();
				});
		} else {
			// Очистка основной обёртки и скрытие предупреждения при сбросе выбора
			mainVarWrap.innerHTML = '';
			warningMessage.style.display = 'none';
		}
	});
	
	// Динамическое обновление иконки Awesome
    function updateAwesomeIcon(input) {
        const awesomeDiv = input.closest('.value-and-unit').querySelector('.awesome');
        if (!awesomeDiv) return;

        const inputValue = input.value.trim();
        if (/^\\f[0-9a-fA-F]{3}$/.test(inputValue)) {
            const iconSymbol = String.fromCharCode(parseInt(inputValue.replace('\\', ''), 16));
            awesomeDiv.setAttribute('data-before', iconSymbol);
            input.classList.remove('input-error');
        } else {
            awesomeDiv.setAttribute('data-before', '');
            input.classList.add('input-error');
        }
    }

    document.addEventListener('input', function(event) {
        if (event.target.tagName === 'INPUT' && event.target.dataset.key) {
            updateAwesomeIcon(event.target);
        }
    });
	
	// Функция для обновления превью изображения
	function updatePreviewImage(input) {
		const previewWrapper = input.closest('.value-url').parentElement.querySelector('.preview-url-image');

		const imageUrl = input.value.trim();

		// Убедимся, что previewWrapper существует
		if (!previewWrapper) {
			console.error('Превью-обертка не найдена');
			return;
		}

		// Если есть значение, проверяем существование файла
		if (imageUrl) {
			fetch(imageUrl, { method: 'HEAD' })
				.then(response => {
					previewWrapper.innerHTML = response.ok
						? `<img src="${imageUrl}" alt="Preview Image" onerror="this.style.display='none'; this.nextElementSibling.style.display='block';">
						   <div class="image-missing" style="display: none;">Упс, файл по этому адресу не найден</div>`
						: `<div class="image-missing">Упс, файл по этому адресу не найден</div>`;
				})
				.catch(() => {
					previewWrapper.innerHTML = `<div class="image-missing">Упс, файл по этому адресу не найден</div>`;
				});
		} else {
			previewWrapper.innerHTML = `<div class="image-empty">Не оставляйте поле пустым :)</div>`;
		}
	}

	// Привязываем обработчик изменения значения для всех URL-полей
	document.addEventListener('input', (event) => {
		const input = event.target;

		// Убедимся, что обновляем только для URL
		if (input.type === 'text' && input.closest('.value-url')) {
			updatePreviewImage(input);
		}
	});

	// Уведомление после успешного сохранения изменений
	function showNotification(message, type = 'info') {
		const notification = document.createElement('div');
		notification.className = `kkb-notification kkb-notification-${type}`;
		notification.textContent = message;
		document.body.appendChild(notification);

		// Плавное появление
		setTimeout(() => {
			notification.classList.add('show');
		}, 10);

		// Убираем уведомление через 3 секунды
		setTimeout(() => {
			notification.classList.remove('show');
			setTimeout(() => notification.remove(), 300); // Удаляем после завершения анимации
		}, 3000);
	}

	// Логика для сохранения изменений + сохранение RGBA и HEX значений
	document.querySelector('.kkb-save-design-settings-button').addEventListener('click', function() {
		const selectedOption = designOptions.value;
		const inputs = document.querySelectorAll('.var-section-wrap input');
		const data = {};

		inputs.forEach(input => {
			const key = input.getAttribute('data-key');
			data[key] = {
				value: input.value,
				type: input.getAttribute('type') === 'text' ? 'color' : input.getAttribute('type')
			};
			
			// Обновляем превью, если это поле для URL
			if (input.getAttribute('type') === 'text' && input.classList.contains('url-input')) {
				updatePreviewImage(input);
			}
			
			// if (input.getAttribute('type') === 'text' && input.id === 'url-input') {
				// updatePreviewImage(input);
			// }
			
			// Обновляем иконку Awesome для текстовых полей
			if (input.getAttribute('type') === 'text') {
				updateAwesomeIcon(input);
			}
		});

		// Используем FormData вместо JSON.stringify
		const formData = new FormData();
		formData.append('action', 'kkb_save_design_settings');
		formData.append('file', selectedOption);
		formData.append('data', JSON.stringify(data));
		
		// Показать прелоадер перед сохранением
		showPreloader();

		fetch(window.kkbData.ajaxUrl, {
			method: 'POST',
			body: formData
		})
		.then(response => response.json())
		.then(responseData => {
			// Скрыть прелоадер сразу
			hidePreloader();

			// Показать сообщение об успешном сохранении
			showNotification(responseData.message || 'Настройки успешно сохранены', 'success');
		})
		.catch(error => {
			console.error('Ошибка сохранения данных:', error);

			// Скрыть прелоадер в случае ошибки
			hidePreloader();

			// Показать сообщение об ошибке
			showNotification('Ошибка сохранения данных.', 'error');
		});
	});

	// Логика для сброса значений (только обновление полей, без сохранения)
	document.querySelector('.kkb-reset-design-settings-button').addEventListener('click', function() {
		const selectedOption = designOptions.value;

		if (selectedOption) {
			fetch(window.kkbData.defaultJsonUrl + selectedOption + '.json')
				.then(response => response.json())
				.then(data => {
					const inputs = document.querySelectorAll('.var-section-wrap input');
					inputs.forEach(input => {
						const key = input.getAttribute('data-key');
						if (data[key]) {
							// Обновляем поле значением по умолчанию
							input.value = data[key].value;
							
							// Если это цветовое поле, обновляем и стиль миниатюры
							if (input.classList.contains('color-field')) {
								const colorThumbnail = input.closest('.clr-field');
								if (colorThumbnail) {
									colorThumbnail.style.color = data[key].value;
								}
							}
							
							// Обновляем превью для URL
							if (input.classList.contains('url-input')) {
								updatePreviewImage(input);
							}
							
							// if (input.id === 'url-input') {
								// updatePreviewImage(input);
							// }
							
							// Обновляем иконку Awesome для текстовых полей
							if (input.getAttribute('type') === 'text') {
								updateAwesomeIcon(input);
							}
						}
					});
				})
				.catch(error => {
					console.error('Ошибка при загрузке данных по умолчанию:', error);
					alert('Не удалось загрузить данные по умолчанию');
				});
		} else {
			alert('Выберите блок перед сбросом значений');
		}
	});
});