jQuery(document).ready(function ($) {
    const fadeInSpeed = 300; // Скорость появления (в миллисекундах)
    const fadeOutSpeed = 300; // Скорость скрытия (в миллисекундах)
    const preloader = $("#kkb-preloader"); // Прелоадер
    const deleteSingleMessage = $(".kkb-hidden-delete-single-css-alert-wrap");
    const deleteAllMessage = $(".kkb-hidden-delete-all-css-alert-wrap");

    // Активация кнопок при выборе опции
    $('#kkb-list-exist-css-options').change(function () {
        const selectedFile = $(this).val();
        $(".kkb-delete-single-css-button, .kkb-reset-single-css-button").prop("disabled", !selectedFile);
    });

    // Показ сообщения для удаления одного файла (с анимацией)
    $(".kkb-delete-single-css-button").click(function () {
        deleteSingleMessage.fadeIn(fadeInSpeed);
    });

    // Подтверждение удаления одного файла
    $(".kkb-yes-delete-single-css-button").click(function () {
        deleteSingleMessage.fadeOut(fadeOutSpeed, function () {
            preloader.fadeIn(fadeInSpeed); // Показываем прелоадер после скрытия диалогового окна
        });
        const selectedFile = $('#kkb-list-exist-css-options').val();

        $.post(ajaxurl, { action: 'kkb_delete_single_css_file', file: selectedFile }, function (response) {
            if (response.success) {
                location.reload(); // Перезагружаем страницу после успешного удаления
            }
        }).always(function () {
            preloader.fadeOut(fadeOutSpeed); // Скрываем прелоадер
        });
    });

    // Отмена удаления одного файла (с анимацией)
    $(".kkb-no-delete-single-css-button").click(function () {
        deleteSingleMessage.fadeOut(fadeOutSpeed);
    });

    // Показ сообщения для удаления всех файлов (с анимацией)
    $(".kkb-delete-all-css-button").click(function () {
        deleteAllMessage.fadeIn(fadeInSpeed);
    });

    // Подтверждение удаления всех файлов
    $(".kkb-yes-delete-all-css-button").click(function () {
        deleteAllMessage.fadeOut(fadeOutSpeed, function () {
            preloader.fadeIn(fadeInSpeed); // Показываем прелоадер после скрытия диалогового окна
        });

        $.post(ajaxurl, { action: 'kkb_delete_all_css_files' }, function (response) {
            if (response.success) {
                location.reload(); // Перезагружаем страницу после успешного удаления
            }
        }).always(function () {
            preloader.fadeOut(fadeOutSpeed); // Скрываем прелоадер
        });
    });

    // Отмена удаления всех файлов (с анимацией)
    $(".kkb-no-delete-all-css-button").click(function () {
        deleteAllMessage.fadeOut(fadeOutSpeed);
    });

    // Сброс выбора
    $(".kkb-reset-single-css-button").click(function () {
        $('#kkb-list-exist-css-options').val('');
        $(".kkb-delete-single-css-button, .kkb-reset-single-css-button").prop("disabled", true);
    });
});