jQuery(document).ready(function ($) {
    const modal = $('#kkb-export-preview-modal');
    const modalContent = $('#kkb-preview-file-list');
    const defaultFileName = kkbExportData.defaultFileName;
    const preloader = $('#kkb-preloader'); // Прелоадер
	const exportButton = $('#kkb-export-button'); // Кнопка экспорта
	const exportStatus = $('#kkb-export-status'); // Элемент для сообщений
    let selectedFiles = []; // Обнуление при каждом использовании

	// Изначально скрываем элемент статуса
    exportStatus.hide();

	// Функция проверки выбранных файлов для активации кнопки
    function updateExportButtonState() {
        exportButton.prop('disabled', selectedFiles.length === 0);
    }
	
	// Функция для обновления текста статуса и управления видимостью
    function setExportStatus(message) {
        if (message) {
            exportStatus.text(message).fadeIn();
        } else {
            exportStatus.text('').fadeOut();
        }
    }

    // Открытие модального окна предварительного просмотра
    $('#kkb-export-preview-button').on('click', function () {
        selectedFiles = []; // Очистка выбранных файлов при открытии модального окна

        // Показать прелоадер
        preloader.fadeIn();

        setExportStatus('Получение списка файлов...');
        $.post(kkbExportData.ajaxUrl, { action: 'kkb_export_preview' }, function (response) {
            if (response.cssFiles.length > 0 || response.jsonFiles.length > 0) {
                const cssFiles = response.cssFiles.map(file => {
                    return `<div><input type="checkbox" class="kkb-file-checkbox" id="file-${file}" value="${file}">
                            <label for="file-${file}">${file}</label></div>`;
                }).join('');

                const jsonFiles = response.jsonFiles.map(file => {
                    return `<div><input type="checkbox" class="kkb-file-checkbox" id="file-${file}" value="${file}">
                            <label for="file-${file}">${file}</label></div>`;
                }).join('');
				
				// Содержание модального окна
                modalContent.html(`
                    <div class="kkb-select-actions">
						<div class="kkb-select-files-title-wrap">
							<h2>Предварительный просмотр</h2>
						</div>
						<div class="kkb-select-files-buttons-wrap">
							<button type="button" id="kkb-select-all" class="kkb-medium-btn kkb-primary-btn kkb-btn">Выбрать всё</button>
							<button type="button" id="kkb-deselect-all" class="kkb-medium-btn kkb-reset-btn kkb-btn">Сбросить всё</button>
						</div>
                    </div>
                    <div class="kkb-columns">
                        <div class="kkb-column">
                            <p>Файлы царских блоков</p>
                            ${cssFiles || '<p class="kkb-no-css-files-for-export">Нет доступных CSS файлов</p>'}
                        </div>
                        <div class="kkb-separator"></div>
                        <div class="kkb-column">
                            <p>Файлы с настройками дизайна</p>
                            ${jsonFiles || '<p class="kkb-no-json-files-for-export">Нет доступных JSON файлов</p>'}
                        </div>
                    </div>
                `);

                // "Выбрать всё" и "Сбросить всё"
                $('#kkb-select-all').on('click', function () {
                    $('.kkb-file-checkbox').prop('checked', true).each(function () {
                        const file = $(this).val();
                        if (!selectedFiles.includes(file)) {
                            selectedFiles.push(file);
                        }
                    });
					updateExportButtonState();
                });

                $('#kkb-deselect-all').on('click', function () {
                    $('.kkb-file-checkbox').prop('checked', false);
                    selectedFiles = [];
					updateExportButtonState();
                });

                // Сохранение выбранных файлов
                $('.kkb-file-checkbox').on('change', function () {
                    const file = $(this).val();
                    if ($(this).is(':checked')) {
                        if (!selectedFiles.includes(file)) {
                            selectedFiles.push(file);
                        }
                    } else {
                        selectedFiles = selectedFiles.filter(f => f !== file);
                    }
					updateExportButtonState();
                });
            } else {
                modalContent.html('<p>Нет доступных файлов для экспорта.</p>');
            }

            // Скрыть прелоадер и показать модальное окно
            preloader.fadeOut();
            modal.addClass('is-visible'); // Показываем окно, добавляя класс is-visible
            setExportStatus('');
        }).fail(function () {
            preloader.fadeOut(); // Скрыть прелоадер даже при ошибке
            setExportStatus('Ошибка при получении списка файлов.');
        });
    });

    // Закрытие модального окна
    $('.kkb-export-modal-close, #kkb-export-preview-modal').on('click', function (event) {
        if (event.target === this) {
            modal.removeClass('is-visible'); // Скрываем окно, убирая класс is-visible
        }
    });

    // Экспорт выбранных файлов
    exportButton.on('click', function () {
        const fileNameInput = $('#kkb-export-filename').val().trim();
        const fileName = fileNameInput !== '' ? fileNameInput : kkbExportData.defaultFileName;

        setExportStatus('Подготовка архива...');

        // Добавляем уникальный параметр в запрос
        const uniqueId = Date.now();

        $.post(kkbExportData.ajaxUrl, {
            action: 'kkb_files_export',
            nonce: kkbExportData.nonce,
            files: selectedFiles,
            fileName: fileName,
            uniqueId: uniqueId // Уникальный параметр
        })
            .done(function (response) {
                if (response.success) {
                    setExportStatus('Архив готов. Проверьте его в папке с загрузками...');

                    // Автоматически скачиваем файл
                    const link = document.createElement('a');
                    link.href = response.data.zipUrl;
                    link.download = fileName;
                    document.body.appendChild(link);
                    link.click();
                    document.body.removeChild(link);

                    // Сброс выбранных файлов после успешного экспорта
                    selectedFiles = [];
                    $('.kkb-file-checkbox').prop('checked', false);
                    updateExportButtonState();
                } else {
					setExportStatus('Эх, не надо было сбрасывать файлы... ' + response.data.message);
                }
            })
            .fail(function () {
                setExportStatus('Ошибка при отправке запроса');
            });
    });

    // Изначально кнопка отключена
    updateExportButtonState();
});