document.addEventListener('DOMContentLoaded', function () {
    const radioButtons = document.querySelectorAll('input[name="folder-to-card"]');
    const saveButton = document.querySelector('.kkb-save-options-button');
    const cssFolderPath = `${window.location.origin}/wp-content/kkb-css/`;
    const missingFilesMessage = document.querySelector('.kkb-options-main-files-missing');

    // Проверка наличия файлов
    function checkCssFiles() {
        fetch(kkbRadioData.ajaxurl, {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: 'action=check_css_files'
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Если массив отсутствующих файлов пуст, скрываем элемент
                if (data.data.missingFiles.length === 0) {
                    missingFilesMessage.style.display = 'none';
                } else {
                    missingFilesMessage.style.display = 'flex';
                    console.warn('Отсутствующие файлы:', data.data.missingFiles);
                }
            } else {
                console.error('Ошибка при проверке файлов:', data);
            }
        })
        .catch(error => console.error('Ошибка при запросе проверки файлов:', error));
    }

    // Выполняем проверку файлов при загрузке страницы
    checkCssFiles();

    function setActiveRadioButton(activeId) {
        let isActiveFound = false;
        radioButtons.forEach(radio => {
            if (radio.id === activeId) {
                radio.checked = true;
                console.log(`Переключатель ${activeId} установлен в checked`);
                addCssFile(activeId);
                isActiveFound = true;
            } else {
                radio.checked = false;
            }
        });
        if (!isActiveFound) {
            console.warn(`Не найден переключатель с id: ${activeId}`);
        }
    }

    fetch(kkbRadioData.ajaxurl, {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body: 'action=kkb_load_active_main_css'
    })
    .then(response => response.json())
    .then(data => {
        console.log('Ответ JSON:', data); // проверяем корректность данных
        if (data.success && data.data && data.data.activeFile) {
            setActiveRadioButton(data.data.activeFile);
        } else {
            console.warn('Ошибка или пустое значение activeFile:', data);
        }
    })
    .catch(error => console.error('Ошибка при загрузке activeFile:', error));

    function addCssFile(id) {
        removeCssFile();
        const link = document.createElement('link');
        link.rel = 'stylesheet';
        link.type = 'text/css';
        link.media = 'all';
        link.href = `${cssFolderPath}${id}.css`;
        link.classList.add('kkb-dynamic-css');
        document.head.appendChild(link);
    }

    function removeCssFile() {
        const existingLink = document.querySelector('link.kkb-dynamic-css');
        if (existingLink) {
            existingLink.remove();
        }
    }

    radioButtons.forEach(radio => {
        radio.addEventListener('change', function () {
            console.log(`Переключатель изменен на: ${this.id}`);
            addCssFile(this.id);
        });
    });

    if (saveButton) {
        saveButton.addEventListener('click', function () {
            const activeRadio = document.querySelector('input[name="folder-to-card"]:checked');
            if (activeRadio) {
                fetch(kkbRadioData.ajaxurl, {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                    body: `action=kkb_save_active_main_css&activeFile=${encodeURIComponent(activeRadio.id)}`
                })
                .then(response => response.json())
                .then(data => {
                    window.handleSaveCompletion(data.success);
                })
                .catch(() => window.handleSaveCompletion(false));
            }
        });
    } else {
        console.warn('Кнопка сохранения не найдена на странице.');
    }
});