// kkb-upload.js

// Элементы интерфейса
const uploadArea = document.querySelector('.kkb-upload-area-wrap');
const preloader = document.getElementById('kkb-preloader'); // Прелоадер
const statusUploadOut = document.querySelector('.kkb-status-upload-out');
const statusUploadIn = document.querySelector('.kkb-status-upload-in');

 // Обёртка для списков выбранных блоков
const infoSelectedBlockWrap = document.querySelector('.kkb-info-selected-block-wrap');

// Изначально показываем "Перетащите сюда файлы" и скрываем "Отпустите мышку"
statusUploadOut.style.display = 'flex';
statusUploadIn.style.display = 'none';

// Скрываем обёртку с информацией о выбранных блоках
infoSelectedBlockWrap.style.display = 'none';

const uploadButton = document.querySelector('.kkb-upload-button');
const resetButton = document.querySelector('.kkb-reset-button');
const blockInstallContainer = document.querySelector('.kkb-block-install');
const blockExistContainer = document.querySelector('.kkb-block-exist');
const blockErrorContainer = document.querySelector('.kkb-block-error');
const blockInstallList = document.getElementById('kkb-block-install-list-name');
const blockExistList = document.getElementById('kkb-block-exist-list-name');
const blockErrorList = document.getElementById('kkb-block-error-list-name');
let selectedFiles = []; // Все выбранные файлы
let installFiles = []; // Только файлы для installList

// Функция для показа/скрытия прелоадера
function togglePreloader(show) {
    if (show) {
        preloader.style.display = 'flex';
    } else {
        preloader.style.display = 'none';
    }
}

// Функция для показа/скрытия обёртки списков с выбранными блоками
function toggleInfoSelectedBlockWrap(show) {
    infoSelectedBlockWrap.style.display = show ? 'block' : 'none';
}

// Функция для обновления отображения списков и активации кнопки
function updateDisplayLists(installList, existList, errorList) {
	// Показываем или скрываем элемент blockInstallContainer в зависимости от содержимого installList
    if (installList.length > 0) {
        blockInstallList.textContent = installList.join(', ');
        blockInstallContainer.style.display = 'flex';
		blockInstallList.style.display = 'block';
    } else {
        blockInstallContainer.style.display = 'none';
		blockInstallList.style.display = 'none';
    }
	
	// Показываем или скрываем элемент blockExistContainer в зависимости от содержимого existList
    if (existList.length > 0) {
        blockExistList.textContent = existList.join(', ');
        blockExistContainer.style.display = 'flex';
		blockExistList.style.display = 'block';
    } else {
        blockExistContainer.style.display = 'none';
		blockExistList.style.display = 'none';
    }

	// Показываем или скрываем элемент blockErrorContainer в зависимости от содержимого errorList
    if (errorList.length > 0) {
        blockErrorList.textContent = errorList.join(', ');
        blockErrorContainer.style.display = 'flex';
		blockErrorList.style.display = 'block';
    } else {
        blockErrorContainer.style.display = 'none';
		blockErrorList.style.display = 'none';
    }
	
	// Показываем или скрываем обёртку, если есть файлы для отображения
    toggleInfoSelectedBlockWrap(installList.length > 0 || existList.length > 0 || errorList.length > 0);

	// Активируем кнопку загрузки, если в installList есть файлы
    uploadButton.disabled = installList.length === 0;
	
	// Скрываем прелоадер после обновления списков
    togglePreloader(false);
}

// Обработка выбранных файлов
function handleFiles(files) {
    selectedFiles = Array.from(files).filter(file => file.name.endsWith('.css'));

    const fileNames = selectedFiles.map(file => file.name);
	
	// Показываем прелоадер перед началом проверки
    togglePreloader(true);

    fetch(kkbUploadData.ajaxurl + '?action=kkb_check_files_exist', {
        method: 'POST',
        body: JSON.stringify({ files: fileNames }),
        headers: {
            'Content-Type': 'application/json',
            'X-Requested-With': 'XMLHttpRequest',
        }
    })
		.then(response => response.json())
		.then(data => {
			const installList = [];
			const existList = [];
			const errorList = [];
			installFiles = []; // Обновляем массив installFiles

			selectedFiles.forEach(file => {
				const fileName = file.name;

				const optionLabels = Object.entries(kkbOptions.optionsFiles)
					.filter(([, value]) => value.file === fileName)
					.map(([, value]) => value.label);

				const additionalLabel = kkbOptions.additionalFiles.find(f => f.file === fileName);
				const allLabels = [...optionLabels, additionalLabel ? additionalLabel.label : null].filter(Boolean);

				if (allLabels.length > 0) {
					if (data.exists.includes(fileName)) {
						existList.push(allLabels.join(' / '));
					} else {
						installList.push(allLabels.join(' / '));
						installFiles.push(file); // Сохраняем файл для загрузки
					}
				} else {
					errorList.push(fileName);
				}
			});

			updateDisplayLists(installList, existList, errorList);
		})
		.catch(error => {
			console.error('Ошибка:', error);
			alert('Ошибка при проверке файлов.');
			togglePreloader(false); // Скрываем прелоадер в случае ошибки
		});
}

// Открытие окна выбора файлов при клике на область
uploadArea.addEventListener('click', () => {
    const input = document.createElement('input');
    input.type = 'file';
    input.accept = '.css';
    input.multiple = true;
    input.click();

    input.onchange = () => handleFiles(input.files);
});

// Drag-and-drop функционал
uploadArea.addEventListener('dragenter', (e) => {
    e.preventDefault();
    e.stopPropagation();
	uploadArea.classList.add("dragover"); // Добавляем класс для визуального выделения
	statusUploadOut.style.display = 'none'; // Скрываем "Перетащите сюда файлы"
    statusUploadIn.style.display = 'flex'; // Показываем "Отпустите мышку"
});

uploadArea.addEventListener('dragover', (e) => {
    e.preventDefault();
    e.stopPropagation();
    uploadArea.classList.add("dragover"); // Поддержка выделения
});

uploadArea.addEventListener('dragleave', (e) => {
    e.preventDefault();
    e.stopPropagation();
	uploadArea.classList.remove("dragover"); // Убираем класс при выходе мышки
	statusUploadOut.style.display = 'flex'; // Показываем "Перетащите сюда файлы"
    statusUploadIn.style.display = 'none'; // Скрываем "Отпустите мышку"
});

uploadArea.addEventListener('drop', (e) => {
    e.preventDefault();
    e.stopPropagation();
	uploadArea.classList.remove("dragover"); // Убираем класс после сброса
	statusUploadOut.style.display = 'flex'; // Возвращаем "Перетащите сюда файлы"
    statusUploadIn.style.display = 'none'; // Скрываем "Отпустите мышку"
    handleFiles(e.dataTransfer.files); // Обработка файлов
});

// Загрузка файлов на сервер
uploadButton.addEventListener('click', () => {
    if (installFiles.length === 0) return; // Проверка наличия файлов в installList

    const formData = new FormData();
    installFiles.forEach((file, index) => {
        formData.append(`file_${index}`, file); // Добавляем только файлы из installList
    });
	
	// Показываем прелоадер перед загрузкой файлов
    togglePreloader(true);

	// Отправляем AJAX-запрос на серверный обработчик
    fetch(kkbUploadData.ajaxurl + '?action=kkb_upload_css_files', {
        method: 'POST',
        body: formData,
        headers: {
            'X-Requested-With': 'XMLHttpRequest',
        }
    }).then(response => response.json())
      .then(data => {
          if (data.success) {
              location.reload(); // Перезагрузка страницы после успешной загрузки
          } else {
              alert('Ошибка загрузки файлов.');
			  togglePreloader(false); // Скрываем прелоадер в случае ошибки
          }
      }).catch(error => {
          console.error('Ошибка:', error);
          alert('Произошла ошибка при загрузке файлов.');
		  togglePreloader(false); // Скрываем прелоадер в случае ошибки
      });
});

// Логика сброса выбранных файлов
resetButton.addEventListener('click', () => {
    selectedFiles = [];
    installFiles = [];
    updateDisplayLists([], [], []); // Скрываем все элементы при сбросе
    uploadButton.disabled = true; // Отключаем кнопку загрузки
	toggleInfoSelectedBlockWrap(false); // Скрываем обёртку
});

// Изначально скрываем все элементы при загрузке страницы и отключаем кнопку загрузки
document.addEventListener('DOMContentLoaded', () => {
    blockInstallContainer.style.display = 'none';
    blockExistContainer.style.display = 'none';
    blockErrorContainer.style.display = 'none';
	
	blockInstallList.style.display = 'none';
	blockExistList.style.display = 'none';
	blockErrorList.style.display = 'none';
	
    uploadButton.disabled = true;
	infoSelectedBlockWrap.style.display = 'none'; // Скрываем обёртку списков с выбранными блоками
});