jQuery(document).ready(function ($) {
    const lessonWrap = $('.kkb-video-lesson-content-wrap');
    const lessonButton = $('.kkb-lesson-button');
	
	// Инициализация Vimeo Player
    const iframe = document.querySelector('.kkb-video-player-wrap iframe');
    const player = new Vimeo.Player(iframe);
	
	// Функция для плавного появления элемента
    const fadeIn = (element, duration = 300) => {
        $(element).css("opacity", 0).css("display", "flex").animate({ opacity: 1 }, duration);
    };

    // Функция для плавного скрытия элемента
    const fadeOut = (element, duration = 300) => {
        $(element).animate({ opacity: 0 }, duration, function () {
            $(this).css("display", "none");
        });
    };

    // Открытие попапа с видео
    lessonButton.on('click', function () {
        fadeIn(lessonWrap);
    });

	// Закрытие попапа при клике за его пределами
	$(document).on("click", ".kkb-video-lesson-content-wrap", function (e) {
		// Проверяем, был ли клик вне kkb-video-lesson-content-window
		if (!$(e.target).closest(".kkb-video-lesson-content-window").length) {
			fadeOut($(this)); // Скрываем обертку kkb-video-lesson-content-wrap
			player.pause(); // Останавливаем видео
		}
	});
	
	// Закрытие попапа при нажатии ESC
    $(document).on('keydown', function (e) {
        if (e.key === 'Escape' || e.keyCode === 27) { // Проверяем код клавиши ESC
			e.preventDefault(); // Предотвращаем действие по умолчанию (например, выход из полноэкранного режима)
            e.stopPropagation(); // Останавливаем распространение события
			
            if (lessonWrap.is(':visible')) { // Проверяем, виден ли элемент
                fadeOut(lessonWrap); // Скрываем элемент
				player.pause(); // Останавливаем видео
            }
        }
    });
});