<?php

// Определяем массив опций с файлами, текстовыми значениями и изображениями
// 14 категорий и 81 разновидность БЛОКОВ (секретных фраз) в настройках рубрики
$options_files = array(
    
	// Материалы
	
	'lesson-small-card-'      => array('file' => 'lesson-small-card.css', 'label' => 'Маленький урок', 'image' => plugins_url('assets/images/preview/preview-lesson-small-card.png', dirname(__FILE__))),
    'lesson-big-card-'        => array('file' => 'lesson-big-card.css', 'label' => 'Большой урок', 'image' => plugins_url('assets/images/preview/preview-lesson-big-card.png', dirname(__FILE__))),
    'lesson-compact-card-'    => array('file' => 'lesson-compact-card.css', 'label' => 'Компактный урок', 'image' => plugins_url('assets/images/preview/preview-lesson-compact-card.png', dirname(__FILE__))),
    
	// Заголовок как Иконка
	
	'cat-icon-card-left-'    => array('file' => 'cat-icon-card.css', 'label' => 'Заголовок как Иконка (слева)', 'image' => plugins_url('assets/images/preview/preview-cat-icon-card-left.png', dirname(__FILE__))),
	'cat-icon-card-center-'    => array('file' => 'cat-icon-card.css', 'label' => 'Заголовок как Иконка (центр)', 'image' => plugins_url('assets/images/preview/preview-cat-icon-card-center.png', dirname(__FILE__))),
	'cat-icon-card-right-'    => array('file' => 'cat-icon-card.css', 'label' => 'Заголовок как Иконка (справа)', 'image' => plugins_url('assets/images/preview/preview-cat-icon-card-right.png', dirname(__FILE__))),
	
	// Заголовок + Иконка
	
	'cat-icon-title-card-left-'    => array('file' => 'cat-icon-title-card.css', 'label' => 'Заголовок + Иконка (слева)', 'image' => plugins_url('assets/images/preview/preview-cat-icon-title-card-left.png', dirname(__FILE__))),
	'cat-icon-title-card-center-'    => array('file' => 'cat-icon-title-card.css', 'label' => 'Заголовок + Иконка (центр)', 'image' => plugins_url('assets/images/preview/preview-cat-icon-title-card-center.png', dirname(__FILE__))),
	'cat-icon-title-card-right-'    => array('file' => 'cat-icon-title-card.css', 'label' => 'Заголовок + Иконка (справа)', 'image' => plugins_url('assets/images/preview/preview-cat-icon-title-card-right.png', dirname(__FILE__))),
	
	// Заголовок + Иконка + Описание + Фон (только центр)
	
	'cat-icon-title-text-card-'    => array('file' => 'cat-icon-title-text-card.css', 'label' => 'Заголовок + Иконка + Описание + Фон (только центр)', 'image' => plugins_url('assets/images/preview/preview-cat-icon-title-text-card.png', dirname(__FILE__))),

	// Заголовок + Фон
	
	'cat-title-bg-card-left-'    => array('file' => 'cat-title-bg-card.css', 'label' => 'Заголовок + Фон (слева)', 'image' => plugins_url('assets/images/preview/preview-cat-title-bg-card-left.png', dirname(__FILE__))),
	'cat-title-bg-card-center-'    => array('file' => 'cat-title-bg-card.css', 'label' => 'Заголовок + Фон (центр)', 'image' => plugins_url('assets/images/preview/preview-cat-title-bg-card-center.png', dirname(__FILE__))),
	'cat-title-bg-card-right-'    => array('file' => 'cat-title-bg-card.css', 'label' => 'Заголовок + Фон (справа)', 'image' => plugins_url('assets/images/preview/preview-cat-title-bg-card-right.png', dirname(__FILE__))),

	// Заголовок БЕЗ фона (без настроек)
	
	'cat-title-card-left-'    => array('file' => 'cat-title-card.css', 'label' => 'Заголовок БЕЗ фона (слева)', 'image' => plugins_url('assets/images/preview/preview-cat-title-card-left.png', dirname(__FILE__))),
	'cat-title-card-center-'    => array('file' => 'cat-title-card.css', 'label' => 'Заголовок БЕЗ фона (центр)', 'image' => plugins_url('assets/images/preview/preview-cat-title-card-center.png', dirname(__FILE__))),
	'cat-title-card-right-'    => array('file' => 'cat-title-card.css', 'label' => 'Заголовок БЕЗ фона (справа)', 'image' => plugins_url('assets/images/preview/preview-cat-title-card-right.png', dirname(__FILE__))),

	// Заголовок + Описание + Фон (только центр)
	
	'cat-title-text-bg-card-' => array('file' => 'cat-title-text-bg-card.css', 'label' => 'Заголовок + Описание + Фон (только центр)', 'image' => plugins_url('assets/images/preview/preview-cat-title-text-bg-card.png', dirname(__FILE__))),
	
	// Заголовок + Описание БЕЗ фона
	
	'cat-title-text-card-left-' => array('file' => 'cat-title-text-card.css', 'label' => 'Заголовок + Описание БЕЗ фона (слева)', 'image' => plugins_url('assets/images/preview/preview-cat-title-text-card-left.png', dirname(__FILE__))),
	'cat-title-text-card-center-' => array('file' => 'cat-title-text-card.css', 'label' => 'Заголовок + Описание БЕЗ фона (центр)', 'image' => plugins_url('assets/images/preview/preview-cat-title-text-card-center.png', dirname(__FILE__))),
	'cat-title-text-card-right-' => array('file' => 'cat-title-text-card.css', 'label' => 'Заголовок + Описание БЕЗ фона (справа)', 'image' => plugins_url('assets/images/preview/preview-cat-title-text-card-right.png', dirname(__FILE__))),
	
	// Заголовок + Кнопка на одной строке
	
	'title-button-one-line-card-' => array('file' => 'title-button-one-line.css', 'label' => 'Заголовок + Кнопка на одной строке', 'image' => plugins_url('assets/images/preview/preview-title-button-one-line-card.png', dirname(__FILE__))),
	
	// Кнопки
	
	'button-' => array('file' => 'button-card.css', 'label' => 'Кнопка - С родным фоном и цветом текста', 'image' => plugins_url('assets/images/preview/preview-button.png', dirname(__FILE__))),
	'button-active-' => array('file' => 'button-card.css', 'label' => 'Кнопка - С родным фоном и цветом текста - Активная', 'image' => plugins_url('assets/images/preview/preview-button-active.png', dirname(__FILE__))),
	'button-one-color-' => array('file' => 'button-card.css', 'label' => 'Кнопка - Одноцветная с фоном', 'image' => plugins_url('assets/images/preview/preview-button-one-color.png', dirname(__FILE__))),
	'button-one-color-active-' => array('file' => 'button-card.css', 'label' => 'Кнопка - Одноцветная с фоном - Активная', 'image' => plugins_url('assets/images/preview/preview-button-one-color-active.png', dirname(__FILE__))),
	'button-no-bg-' => array('file' => 'button-card.css', 'label' => 'Кнопка - Одноцветная ссылка БЕЗ фона', 'image' => plugins_url('assets/images/preview/preview-button-no-bg.png', dirname(__FILE__))),
	'button-no-bg-active-' => array('file' => 'button-card.css', 'label' => 'Кнопка - Одноцветная ссылка БЕЗ фона - Активная', 'image' => plugins_url('assets/images/preview/preview-button-no-bg-active.png', dirname(__FILE__))),

	// Баннер горизонтальный
	
	'banner-card-1-'    => array('file' => 'banner-card-1.css', 'label' => 'Баннер - Горизонтальный', 'image' => plugins_url('assets/images/preview/preview-banner-card-1.png', dirname(__FILE__))),
	
	// Баннер вертикальный
	
	'vertical-banner-text-card-'    => array('file' => 'vertical-banner-card.css', 'label' => 'Баннер - Вертикальный - С описанием', 'image' => plugins_url('assets/images/preview/preview-vertical-banner-text-card.png', dirname(__FILE__))),
	'vertical-banner-card-'    => array('file' => 'vertical-banner-card.css', 'label' => 'Баннер - Вертикальный - БЕЗ описания', 'image' => plugins_url('assets/images/preview/preview-vertical-banner-card.png', dirname(__FILE__))),
	
	// Иконка + Заголовок + Отзыв (компакт) (4 в ряд)
	
	'icon-4-feedback-1-card-'    => array('file' => 'icon-4-feedback-1-card.css', 'label' => 'Иконка + Заголовок + Отзыв (компакт) (4 в ряд)', 'image' => plugins_url('assets/images/preview/preview-icon-4-feedback-1-card.png', dirname(__FILE__))),

	// Иконка + Заголовок + Подзаголовок (4 в ряд)
	
	'icon-4-title-subtitle-card-'    => array('file' => 'icon-4-title-subtitle-card.css', 'label' => 'Иконка + Заголовок + Подзаголовок (4 в ряд)', 'image' => plugins_url('assets/images/preview/preview-icon-4-title-subtitle-card.png', dirname(__FILE__))),
	
	// Иконка (6 в ряд)
	
	'icon-6-card-'    => array('file' => 'icon-6-card.css', 'label' => 'Иконка (6 в ряд) - Без подсказки', 'image' => plugins_url('assets/images/preview/preview-icon-6-card.png', dirname(__FILE__))),
	'icon-6-tip-card-'    => array('file' => 'icon-6-card.css', 'label' => 'Иконка (6 в ряд) - Всплывающая подсказка', 'image' => plugins_url('assets/images/preview/preview-icon-6-tip-card.png', dirname(__FILE__))),
	'icon-6-tip-fix-card-'    => array('file' => 'icon-6-card.css', 'label' => 'Иконка (6 в ряд) - Фиксированная подсказка', 'image' => plugins_url('assets/images/preview/preview-icon-6-tip-fix-card.png', dirname(__FILE__))),
	
	// Иконка + Заголовок (вариант 1) (6 в ряд)
	
	'icon-6-title-1-card-'    => array('file' => 'icon-6-title-1-card.css', 'label' => 'Иконка + Заголовок (вариант 1) (6 в ряд) - Без подсказки', 'image' => plugins_url('assets/images/preview/preview-icon-6-title-1-card.png', dirname(__FILE__))),
	'icon-6-title-1-tip-card-'    => array('file' => 'icon-6-title-1-card.css', 'label' => 'Иконка + Заголовок (вариант 1) (6 в ряд) - Всплывающая подсказка', 'image' => plugins_url('assets/images/preview/preview-icon-6-title-1-tip-card.png', dirname(__FILE__))),
	'icon-6-title-1-tip-fix-card-'    => array('file' => 'icon-6-title-1-card.css', 'label' => 'Иконка + Заголовок (вариант 1) (6 в ряд) - Фиксированная подсказка', 'image' => plugins_url('assets/images/preview/preview-icon-6-title-1-tip-fix-card.png', dirname(__FILE__))),
	
	// Иконка + Заголовок (вариант 2) (6 в ряд)
	
	'icon-6-title-2-card-'    => array('file' => 'icon-6-title-2-card.css', 'label' => 'Иконка + Заголовок (вариант 2) (6 в ряд) - Без подсказки', 'image' => plugins_url('assets/images/preview/preview-icon-6-title-2-card.png', dirname(__FILE__))),
	'icon-6-title-2-tip-card-'    => array('file' => 'icon-6-title-2-card.css', 'label' => 'Иконка + Заголовок (вариант 2) (6 в ряд) - Всплывающая подсказка', 'image' => plugins_url('assets/images/preview/preview-icon-6-title-2-tip-card.png', dirname(__FILE__))),
	'icon-6-title-2-tip-fix-card-'    => array('file' => 'icon-6-title-2-card.css', 'label' => 'Иконка + Заголовок (вариант 2) (6 в ряд) - Фиксированная подсказка', 'image' => plugins_url('assets/images/preview/preview-icon-6-title-2-tip-fix-card.png', dirname(__FILE__))),

	// Иконка + Заголовок + Кнопка (6 в ряд)
	
	'icon-6-title-button-card-'    => array('file' => 'icon-6-title-button-card.css', 'label' => 'Иконка + Заголовок + Кнопка (6 в ряд)', 'image' => plugins_url('assets/images/preview/preview-icon-6-title-button-card.png', dirname(__FILE__))),

	// Вопрос-Ответ
	
	'faq-card-'    => array('file' => 'faq-card.css', 'label' => 'Вопрос-Ответ', 'image' => plugins_url('assets/images/preview/preview-faq-card.png', dirname(__FILE__))),
	'faq-card-before-last-'    => array('file' => 'faq-card.css', 'label' => 'Вопрос-Ответ: ПРЕДпоследний вопрос', 'image' => plugins_url('assets/images/preview/preview-faq-card-before-last.png', dirname(__FILE__))),
	'faq-card-last-'    => array('file' => 'faq-card.css', 'label' => 'Вопрос-Ответ: Последний вопрос', 'image' => plugins_url('assets/images/preview/preview-faq-card-last.png', dirname(__FILE__))),
	
	// Карточка - Текстовая
	
	'info-card-'    => array('file' => 'info-card.css', 'label' => 'Карточка - Текстовая - Без обводки', 'image' => plugins_url('assets/images/preview/preview-info-card.png', dirname(__FILE__))),
	'info-border-card-'    => array('file' => 'info-card.css', 'label' => 'Карточка - Текстовая - С обводкой', 'image' => plugins_url('assets/images/preview/preview-info-border-card.png', dirname(__FILE__))),
	
	// Карточка - Текстовая креативная
	
	'info-creative-card-'    => array('file' => 'info-creative-card.css', 'label' => 'Карточка - Текстовая - Креативная', 'image' => plugins_url('assets/images/preview/preview-info-creative-card.png', dirname(__FILE__))),
	
	// Карточка с кнопкой - Товар
	
	'product-card-'    => array('file' => 'product-card.css', 'label' => 'Карточка с кнопкой - Товар', 'image' => plugins_url('assets/images/preview/preview-product-card.png', dirname(__FILE__))),
	
	// Карточка с кнопкой - Скачать
	
	'download-card-'    => array('file' => 'download-card.css', 'label' => 'Карточка с кнопкой - Скачать', 'image' => plugins_url('assets/images/preview/preview-download-card.png', dirname(__FILE__))),
	
	// Карточка с кнопкой - Лендинг
	
	'landing-card-'    => array('file' => 'landing-card.css', 'label' => 'Карточка с кнопкой - Лендинг', 'image' => plugins_url('assets/images/preview/preview-landing-card.png', dirname(__FILE__))),
	
	// Информация с кнопкой
	
	'info-button-card-'    => array('file' => 'info-button-card.css', 'label' => 'Карточка - Информация с кнопкой', 'image' => plugins_url('assets/images/preview/preview-info-button-card.png', dirname(__FILE__))),
	
	// Карточка - Письмо с анимацией
	
	'letter-card-'    => array('file' => 'letter-card.css', 'label' => 'Карточка - Письмо с анимацией', 'image' => plugins_url('assets/images/preview/preview-letter-card.png', dirname(__FILE__))),
	
	// Карточка - Закрытое письмо
	
	'letter-close-card-'    => array('file' => 'letter-close-card.css', 'label' => 'Карточка - Закрытое письмо', 'image' => plugins_url('assets/images/preview/preview-letter-close-card.png', dirname(__FILE__))),
	
	// Карточка - Шторка с анимацией
	
	'curtain-card-'    => array('file' => 'curtain-card.css', 'label' => 'Карточка - Шторка с анимацией - Классика', 'image' => plugins_url('assets/images/preview/preview-curtain-card.png', dirname(__FILE__))),
	'curtain-card-fuck-'    => array('file' => 'curtain-card.css', 'label' => 'Карточка - Шторка с анимацией - С факушками', 'image' => plugins_url('assets/images/preview/preview-curtain-card-fuck.png', dirname(__FILE__))),
	
	// Карточка - Скрытая сбоку школы
	
	'surprise-card-'    => array('file' => 'surprise-card.css', 'label' => 'Карточка - Скрытая сбоку школы', 'image' => plugins_url('assets/images/preview/preview-surprise-card.png', dirname(__FILE__))),
	
	// Карточка - Плеер
	
	'player-1-card-'    => array('file' => 'player-card.css', 'label' => 'Карточка - Плеер - Компактный урок', 'image' => plugins_url('assets/images/preview/preview-player-1-card.png', dirname(__FILE__))),
	'player-2-card-'    => array('file' => 'player-card.css', 'label' => 'Карточка - Плеер - Ползущий прогресс', 'image' => plugins_url('assets/images/preview/preview-player-2-card.png', dirname(__FILE__))),
	'player-3-card-'    => array('file' => 'player-card.css', 'label' => 'Карточка - Плеер - Неподвижный прогресс', 'image' => plugins_url('assets/images/preview/preview-player-3-card.png', dirname(__FILE__))),
	'player-gif-card-'    => array('file' => 'player-card.css', 'label' => 'Карточка - Плеер - Анимированная обложка', 'image' => plugins_url('assets/images/preview/preview-player-gif-card.png', dirname(__FILE__))),
	
	// Невидимый параграф
	
	'paragraph-card-0-'    => array('file' => 'paragraph-card.css', 'label' => 'Параграф - Невидимый - Без отступа по вертикали', 'image' => plugins_url('assets/images/preview/preview-paragraph-card-0.png', dirname(__FILE__))),
	'paragraph-card-60-'    => array('file' => 'paragraph-card.css', 'label' => 'Параграф - Невидимый - С двойным отступом по вертикали', 'image' => plugins_url('assets/images/preview/preview-paragraph-card-60.png', dirname(__FILE__))),
	
	// Разделительная линия
	
	'line-card-'    => array('file' => 'line-card.css', 'label' => 'Параграф - Разделительная линия', 'image' => plugins_url('assets/images/preview/preview-line-card.png', dirname(__FILE__))),

	// Обложка стандартная
	
	'cover-card-'    => array('file' => 'cover-card.css', 'label' => 'Обложка - Стандартная', 'image' => plugins_url('assets/images/preview/preview-cover-card.png', dirname(__FILE__))),
	
	// Обложка маленькая
	
	'mini-cover-card-'    => array('file' => 'min-cover-card.css', 'label' => 'Обложка - Маленькая', 'image' => plugins_url('assets/images/preview/preview-mini-cover-card.png', dirname(__FILE__))),
	
	// Календарь с датами
	
	'calendar-card-1-'    => array('file' => 'calendar-card.css', 'label' => 'Дата - С фоном + Кружок', 'image' => plugins_url('assets/images/preview/preview-calendar-card-1.png', dirname(__FILE__))),
	'calendar-card-1-fix-'    => array('file' => 'calendar-card.css', 'label' => 'Дата - С фоном + Кружок - Активная', 'image' => plugins_url('assets/images/preview/preview-calendar-card-1-fix.png', dirname(__FILE__))),
	
	'calendar-card-3-'    => array('file' => 'calendar-card.css', 'label' => 'Дата - С фоном БЕЗ кружка', 'image' => plugins_url('assets/images/preview/preview-calendar-card-3.png', dirname(__FILE__))),
	'calendar-card-3-fix-'    => array('file' => 'calendar-card.css', 'label' => 'Дата - С фоном БЕЗ кружка - Активная', 'image' => plugins_url('assets/images/preview/preview-calendar-card-3-fix.png', dirname(__FILE__))),
	
	'calendar-card-2-'    => array('file' => 'calendar-card.css', 'label' => 'Дата - БЕЗ фона + Кружок', 'image' => plugins_url('assets/images/preview/preview-calendar-card-2.png', dirname(__FILE__))),
	'calendar-card-2-fix-'    => array('file' => 'calendar-card.css', 'label' => 'Дата - БЕЗ фона + Кружок - Активная', 'image' => plugins_url('assets/images/preview/preview-calendar-card-2-fix.png', dirname(__FILE__))),
	
	'calendar-card-4-'    => array('file' => 'calendar-card.css', 'label' => 'Дата - БЕЗ фона и БЕЗ кружка', 'image' => plugins_url('assets/images/preview/preview-calendar-card-4.png', dirname(__FILE__))),
	'calendar-card-4-fix-'    => array('file' => 'calendar-card.css', 'label' => 'Дата - БЕЗ фона и БЕЗ кружка - Активная', 'image' => plugins_url('assets/images/preview/preview-calendar-card-4-fix.png', dirname(__FILE__))),
	
	// Время
	
	'time-card-'    => array('file' => 'time-card.css', 'label' => 'Время - Открытое', 'image' => plugins_url('assets/images/preview/preview-time-card.png', dirname(__FILE__))),
	'time-card-fix-'    => array('file' => 'time-card.css', 'label' => 'Время - Активное', 'image' => plugins_url('assets/images/preview/preview-time-card-fix.png', dirname(__FILE__))),
	'time-card-close-'    => array('file' => 'time-card.css', 'label' => 'Время - Закрытое', 'image' => plugins_url('assets/images/preview/preview-time-card-close.png', dirname(__FILE__))),
	
	'time-card-tip-'    => array('file' => 'time-card.css', 'label' => 'Время - Открытое - Всплывающая подсказка', 'image' => plugins_url('assets/images/preview/preview-time-card-tip.png', dirname(__FILE__))),
	'time-card-fix-tip-'    => array('file' => 'time-card.css', 'label' => 'Время - Активное - Всплывающая подсказка', 'image' => plugins_url('assets/images/preview/preview-time-card-fix-tip.png', dirname(__FILE__))),
	
	'time-card-tip-fix-'    => array('file' => 'time-card.css', 'label' => 'Время - Открытое - Фиксированная подсказка', 'image' => plugins_url('assets/images/preview/preview-time-card-tip-fix.png', dirname(__FILE__))),
	'time-card-fix-tip-fix-'    => array('file' => 'time-card.css', 'label' => 'Время - Активное - Фиксированная подсказка', 'image' => plugins_url('assets/images/preview/preview-time-card-fix-tip-fix.png', dirname(__FILE__))),

);

// Дополнительные файлы с указанием label для каждого
// Список всех ОБЯЗАТЕЛЬНЫХ css-файлов
// 2 обязательные категории - Базовые блоки (3 типа дизайна) и Дополнительные функции
$additional_files = array(
    array(
        'file' => 'folder-to-card-3.css',
        'label' => 'Классическая карточка (3 в ряд)',
		'group' => 'Классические карточки'
    ),
    array(
        'file' => 'folder-to-card-4.css',
        'label' => 'Классическая карточка (4 в ряд)',
		'group' => 'Классические карточки'
    ),
    array(
        'file' => 'folder-to-card-5.css',
        'label' => 'Классическая карточка (5 в ряд)',
		'group' => 'Классические карточки'
    ),
    array(
        'file' => 'off-card.css',
        'label' => 'Функция некликабельности блока'
    ),
    array(
        'file' => 'move-to-right-card.css',
        'label' => 'Функция обтекания блока слева'
    )
);

// Массив для чекбоксов с соответствием файлов и block для каждого
// Список всех css-файлов для БЛОКОВ Царского набора
// 14 категорий и 38 уникальных типов блоков (css-файлов для блоков)
$checkbox_files = array(
    array(
        'file' => 'lesson-small-card.css',
        'block' => 'Маленький урок',
		'group' => 'В стиле материала'
    ),
    array(
        'file' => 'lesson-big-card.css',
        'block' => 'Большой урок',
		'group' => 'В стиле материала'
    ),
    array(
        'file' => 'lesson-compact-card.css',
        'block' => 'Компактный урок',
		'group' => 'В стиле материала'
    ),
	array(
        'file' => 'cat-icon-card.css',
        'block' => 'Заголовок как иконка',
		'group' => 'Заголовок как иконка'
    ),
	array(
        'file' => 'cat-icon-title-card.css',
        'block' => 'Заголовок + Иконка',
		'group' => 'Заголовок + Иконка'
    ),
	array(
        'file' => 'cat-icon-title-text-card.css',
        'block' => 'Заголовок + Иконка + Описание + Фон',
		'group' => 'Заголовок + Иконка + Описание + Фон'
    ),
	array(
        'file' => 'cat-title-bg-card.css',
        'block' => 'Заголовок + Фон',
		'group' => 'Заголовок + Фон'
    ),
	array(
        'file' => 'cat-title-card.css',
        'block' => 'Заголовок БЕЗ фона (без настроек)',
		'group' => 'Заголовок БЕЗ фона'
    ),
	array(
        'file' => 'cat-title-text-bg-card.css',
        'block' => 'Заголовок + Описание + Фон',
		'group' => 'Заголовок + Описание + Фон'
    ),
	array(
        'file' => 'cat-title-text-card.css',
        'block' => 'Заголовок + Описание БЕЗ фона',
		'group' => 'Заголовок + Описание БЕЗ фона'
    ),
	array(
        'file' => 'title-button-one-line.css',
        'block' => 'Заголовок + Кнопка на одной строке',
		'group' => 'Заголовок + Кнопка на одной строке'
    ),
	array(
        'file' => 'button-card.css',
        'block' => 'Кнопки - Обычные',
		'group' => 'Кнопки'
    ),
	array(
        'file' => 'banner-card-1.css',
        'block' => 'Баннер - Горизонтальный',
		'group' => 'Баннеры'
    ),
	array(
        'file' => 'vertical-banner-card.css',
        'block' => 'Баннеры - Вертикальные',
		'group' => 'Баннеры'
    ),
	array(
        'file' => 'icon-4-feedback-1-card.css',
        'block' => 'Иконка + Заголовок + Отзыв (компакт) (4 в ряд)',
		'group' => 'Иконки'
    ),
	array(
        'file' => 'icon-4-title-subtitle-card.css',
        'block' => 'Иконка + Заголовок + Подзаголовок (4 в ряд)',
		'group' => 'Иконки'
    ),
	array(
        'file' => 'icon-6-card.css',
        'block' => 'Иконка (6 в ряд)',
		'group' => 'Иконки'
    ),
	array(
        'file' => 'icon-6-title-1-card.css',
        'block' => 'Иконка + Заголовок (вариант 1) (6 в ряд)',
		'group' => 'Иконки'
    ),
	array(
        'file' => 'icon-6-title-2-card.css',
        'block' => 'Иконка + Заголовок (вариант 2) (6 в ряд)',
		'group' => 'Иконки'
    ),
	array(
        'file' => 'icon-6-title-button-card.css',
        'block' => 'Иконка + Заголовок + Кнопка (6 в ряд)',
		'group' => 'Иконки'
    ),
	array(
        'file' => 'faq-card.css',
        'block' => 'Вопрос-Ответ',
		'group' => 'Списки'
    ),
	array(
        'file' => 'info-card.css',
        'block' => 'Карточка - Текстовая',
		'group' => 'Карточки текстовые'
    ),
	array(
        'file' => 'info-creative-card.css',
        'block' => 'Карточка - Текстовая - Креативная',
		'group' => 'Карточки текстовые'
    ),
	array(
        'file' => 'product-card.css',
        'block' => 'Карточка с кнопкой - Товар',
		'group' => 'Карточки с кнопкой'
    ),
	array(
        'file' => 'download-card.css',
        'block' => 'Карточка с кнопкой - Скачать',
		'group' => 'Карточки с кнопкой'
    ),
	array(
        'file' => 'landing-card.css',
        'block' => 'Карточка с кнопкой - Лендинг',
		'group' => 'Карточки с кнопкой'
    ),
	array(
        'file' => 'info-button-card.css',
        'block' => 'Карточка - Информация с кнопкой',
		'group' => 'Карточки с кнопкой'
    ),
	array(
        'file' => 'letter-card.css',
        'block' => 'Карточка - Письмо с анимацией',
		'group' => 'Карточки креативные'
    ),
	array(
        'file' => 'letter-close-card.css',
        'block' => 'Карточка - Закрытое письмо',
		'group' => 'Карточки креативные'
    ),
	array(
        'file' => 'curtain-card.css',
        'block' => 'Карточка - Шторка с анимацией',
		'group' => 'Карточки креативные'
    ),
	array(
        'file' => 'surprise-card.css',
        'block' => 'Карточка - Скрытая сбоку школы',
		'group' => 'Карточки креативные'
    ),
	array(
        'file' => 'player-card.css',
        'block' => 'Карточка - Плеер',
		'group' => 'Карточки как плеер'
    ),
	array(
        'file' => 'paragraph-card.css',
        'block' => 'Параграфы - Невидимые',
		'group' => 'Параграфы'
    ),
	array(
        'file' => 'line-card.css',
        'block' => 'Параграф - Разделительная линия',
		'group' => 'Параграфы'
    ),
	array(
        'file' => 'cover-card.css',
        'block' => 'Обложка - Стандартная',
		'group' => 'Обложки'
    ),
	array(
        'file' => 'min-cover-card.css',
        'block' => 'Обложка - Маленькая',
		'group' => 'Обложки'
    ),
	array(
        'file' => 'calendar-card.css',
        'block' => 'Календарь с датами',
		'group' => 'Календарь'
    ),
	array(
        'file' => 'time-card.css',
        'block' => 'Время - Обычное',
		'group' => 'Время'
    ),
	array(
        'file' => 'off-card.css',
        'block' => 'Некликабельность',
		'group' => 'Дополнительные функции'
    ),
	array(
        'file' => 'move-to-right-card.css',
        'block' => 'Обтекание слева',
		'group' => 'Дополнительные функции'
    )
);

// Передача массивов для JavaScript
add_action('admin_enqueue_scripts', function() use ($options_files, $additional_files) {
    wp_localize_script('kkb-upload-script', 'kkbOptions', [
        'optionsFiles' => $options_files,
        'additionalFiles' => $additional_files,
    ]);
});