<?php

function wpm_add_slug_options() {
    // if (isset($_GET['taxonomy']) && $_GET['taxonomy'] === 'wpm-category') {
	
	// Глобальная переменная, чтобы знать, какая именно это админ-страница (term.php, edit-tags.php)
	global $pagenow;

	// Проверяем, что мы именно в term.php (это файл страницы редактирования термина)
    // и что в URL присутствуют taxonomy=wpm-category и tag_ID=<число>
    if (
        $pagenow === 'term.php'
        && isset($_GET['taxonomy']) && $_GET['taxonomy'] === 'wpm-category'
        && isset($_GET['tag_ID']) && is_numeric($_GET['tag_ID'])
    ) {	

        // Путь к папке wp-content/kkb-css
        $test_files_dir = WP_CONTENT_DIR . '/kkb-css/';
        
        global $options_files; 
        global $additional_files; 
        global $checkbox_files; // Добавлено для работы с 'group'

        // Список файлов, которые нужно исключить из выпадающего списка
        $excluded_files = ['shapka-logo-2.css'];

        // HTML для выбора блока в select
        $select_html = '<th scope="row"><label for="slug-options">★ Превратить в</label></th>';
        $select_html .= '<td><select id="slug-options" name="slug-options" onchange="updateSlug()">';
        $select_html .= '<option value="">Выберите блок</option>';

        // Создаём массив для группировки опций
        $grouped_options = array();

        foreach ($options_files as $option_value => $data) {
            // Пропускаем опции, если их файл в списке исключённых
            if (in_array($data['file'], $excluded_files)) {
                continue;
            }

            if (file_exists($test_files_dir . $data['file'])) {
                // Ищем соответствующий файл в $checkbox_files, чтобы найти 'group'
                $group_name = 'Без группы'; // Значение по умолчанию
                foreach ($checkbox_files as $checkbox) {
                    if ($checkbox['file'] === $data['file'] && !empty($checkbox['group'])) {
                        $group_name = $checkbox['group'];
                        break;
                    }
                }

                // Группируем опции по найденному 'group'
                if (!isset($grouped_options[$group_name])) {
                    $grouped_options[$group_name] = array();
                }
                $grouped_options[$group_name][] = '<option value="' . esc_attr($option_value) . '">' . esc_html($data['label']) . '</option>';
            }
        }

        // Генерируем HTML-код для группированных опций
        foreach ($grouped_options as $group_name => $options) {
            if ($group_name !== 'Без группы') {
                $select_html .= '<optgroup label="' . esc_attr($group_name) . '">';
            }
            $select_html .= implode("\n", $options); // Добавляем опции в группу
            if ($group_name !== 'Без группы') {
                $select_html .= '</optgroup>';
            }
        }

        $select_html .= '</select>
		
		<div class="get-king-kit-blocks">
			<p class="get-king-kit-blocks-message">Хотите больше блоков? Скачайте их <a target="_blank" rel="noopener" href="https://memberlux.online/redirect-download-king-kit-blocks">здесь</a></p>
		</div>
		
		<div class="block-not-activated">
			<p class="block-not-activated-message">Активируйте этот блок на странице «1. Установить блоки», чтобы он заработал</p>
		</div>
		
		<div class="image-block-design"><img src="" alt="Preview" id="image-preview" /></div>
	
		</td>';

        // HTML для отображения текущего дизайна
        $current_design_html = '<th scope="row"><label>★ Текущий дизайн</label></th>';
		
        $current_design_html .= '<td><p class="name-current-block-design">Классическая карточка</p>';
		
        $current_design_html .= '<div class="current-block-file-missing" style="display: none;">
		<p class="current-block-file-missing-message">Отсутствует css-файл текущего дизайна. Установите его или выберите из списка другой блок</p></div>';
		
        $main_file_missing_html = '<div class="main-file-missing" style="display: none;">
		<p class="main-file-missing-message">Отсутствует один или несколько обязательных css-файлов Царского набора. Установите их, чтобы заработали блоки</p></div>';
		
        $current_design_html .= $main_file_missing_html; 
        $current_design_html .= '</td>';
        $current_design_html .= '<input type="hidden" id="saved-design" name="saved-design" value="Классическая карточка">'; 

        // HTML для дополнительных настроек
        $special_settings_html = '<th scope="row"><label for="special-settings">★ Доп. функции</label></th>';
        $special_settings_html .= '<td><div class="checkbox-block">';
        $special_settings_html .= '<div class="checkbox-and-label"><input type="checkbox" id="off-block" value="off-"> <label for="off-block">Сделать рубрику некликабельной</label></div>';
        $special_settings_html .= '<div class="checkbox-and-label"><input type="checkbox" id="move-to-right-block" value="move-to-right-"> <label for="move-to-right-block">Обтекать эту рубрику слева</label></div>';
        $special_settings_html .= '</div></td>';
		
		// HTML для элемента-строки с линией
        $separator_line_edit_html = '<th scope="row"><div class="separator-line"></div></th>';
        $separator_line_edit_html .= '<td><div class="separator-line"></div></td>';

        ?>
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                var formTable = document.querySelector('table.form-table');
                if (formTable) {
                    var optionsRow = document.createElement('tr');
                    optionsRow.classList.add('form-field', 'secret-phrases-list');
                    optionsRow.innerHTML = `<?php echo $select_html; ?>`;

                    var currentDesignRow = document.createElement('tr');
                    currentDesignRow.classList.add('form-field', 'current-block-design');
                    currentDesignRow.innerHTML = `<?php echo $current_design_html; ?>`;

                    var specialSettingsRow = document.createElement('tr');
                    specialSettingsRow.classList.add('form-field', 'special-block-settings');
                    specialSettingsRow.innerHTML = `<?php echo $special_settings_html; ?>`;
					
					// Создаём элемент-строку с линией
					
					var separatorLineRow = document.createElement('tr');
                    separatorLineRow.classList.add('form-field', 'separator-line-edit-cat');
                    separatorLineRow.innerHTML = `<?php echo $separator_line_edit_html; ?>`;

                    var firstRow = formTable.querySelector('tr.form-field');
                    if (firstRow) {
                        firstRow.insertAdjacentElement('afterend', optionsRow);
                        optionsRow.insertAdjacentElement('afterend', currentDesignRow);
                        currentDesignRow.insertAdjacentElement('afterend', specialSettingsRow);
						// Добавляем элемент-строку с линией
						specialSettingsRow.insertAdjacentElement('afterend', separatorLineRow);
                    }

                    window.optionsFiles = <?php 
                        echo json_encode(array_map(function($data) use ($test_files_dir) {
                            return array_merge($data, [
                                'fileExists' => file_exists($test_files_dir . $data['file'])
                            ]);
                        }, $options_files)); 
                    ?>;

                    window.additionalFiles = <?php 
						echo json_encode(array_map(function($data) use ($test_files_dir) {
							return array(
								'file' => $data['file'],
								'label' => $data['label'],
								'fileExists' => file_exists($test_files_dir . $data['file'])
							);
						}, $additional_files)); 
					?>;

                }
            });
        </script>
        <?php
    }
}
// Подключение функции для отображения HTML опций
add_action( 'admin_footer', 'wpm_add_slug_options' );