<?php
// Файл: kkb-files-export.php

if (!defined('ABSPATH')) {
    exit; // Защита от прямого доступа
}

// Подключаем CSS и JS для стилей и функционала
function kkb_files_export_enqueue_assets() {
    wp_enqueue_style('kkb-files-export-css', plugins_url('../assets/css/kkb-files-export.css', __FILE__));
    wp_enqueue_script('kkb-files-export-js', plugins_url('../assets/js/kkb-files-export.js', __FILE__), array('jquery'), null, true);

    // Передаём PHP данные в JS
    wp_localize_script('kkb-files-export-js', 'kkbExportData', array(
        'ajaxUrl' => admin_url('admin-ajax.php'),
        'defaultFileName' => 'kkb-export-' . date('Y-m-d') . '.zip',
        'nonce' => wp_create_nonce('kkb-files-export-nonce'),
    ));
}
add_action('admin_enqueue_scripts', 'kkb_files_export_enqueue_assets');

// Обработчик AJAX для предварительного просмотра
function kkb_files_export_preview() {
    $directory = WP_CONTENT_DIR . '/kkb-css/';
    $cssFiles = [];
    $jsonFiles = [];

    if (is_dir($directory)) {
        foreach (glob($directory . '*.css') as $file) {
            $cssFiles[] = basename($file);
        }
        foreach (glob($directory . '*.json') as $file) {
            $jsonFiles[] = basename($file);
        }
    }

    sort($cssFiles); // Сортировка по алфавиту
    sort($jsonFiles);

    wp_send_json(array(
        'cssFiles' => $cssFiles,
        'jsonFiles' => $jsonFiles,
    ));
}
add_action('wp_ajax_kkb_export_preview', 'kkb_files_export_preview');

// Обработчик AJAX для экспорта выбранных файлов
function kkb_files_export() {
    check_ajax_referer('kkb-files-export-nonce', 'nonce');

    $selectedFiles = isset($_POST['files']) ? array_map('sanitize_text_field', $_POST['files']) : [];
    $fileName = sanitize_text_field($_POST['fileName']);
    if (empty($fileName)) {
        // Добавляем уникальный идентификатор к имени файла по умолчанию
        $fileName = 'kkb-export-' . date('Y-m-d') . '-' . uniqid() . '.zip';
    }

    if (empty($selectedFiles)) {
        wp_send_json_error(array('message' => 'Выберите их ещё раз.'));
    }

    $directory = WP_CONTENT_DIR . '/kkb-css/';
    $uploadDir = WP_CONTENT_DIR . '/uploads/kkb-exports/'; // Директория для временных файлов
    $zipPath = $uploadDir . $fileName;
	
	// Убеждаемся, что директория существует
    if (!file_exists($uploadDir)) {
        mkdir($uploadDir, 0755, true);
    }

    $zip = new ZipArchive();
    if ($zip->open($zipPath, ZipArchive::CREATE | ZipArchive::OVERWRITE) === TRUE) {
        foreach ($selectedFiles as $file) {
            $filePath = $directory . $file;
            if (file_exists($filePath)) {
                $zip->addFile($filePath, $file);
            }
        }
        $zip->close();
		
		// Удаляем временный файл через cron
        wp_schedule_single_event(time() + 3600, 'kkb_cleanup_temp_file', array($zipPath));

        wp_send_json_success(array('zipUrl' => content_url('uploads/kkb-exports/' . $fileName)));
    } else {
        wp_send_json_error(array('message' => 'Не удалось создать ZIP-архив.'));
    }
}
add_action('wp_ajax_kkb_files_export', 'kkb_files_export');

// Удаление временных файлов через cron
function kkb_cleanup_temp_file($filePath) {
    if (file_exists($filePath)) {
        unlink($filePath);
    }
}
add_action('kkb_cleanup_temp_file', 'kkb_cleanup_temp_file');

// Функция для отображения страницы настроек плагина
function kkb_files_export_page() {
    ?>
	<div class="kkb-main-wrap kkb-files-export-page">

		<!-- Меню -->
		
		<div class="kkb-menu-wrap">
			<div class="kkb-menu-logo">
				<h2>
					<span class="color-accent-2">Царский</span>
					<span class="color-accent-1">набор рубрик</span>
				</h2>
			</div>

			<div class="kkb-menu-links">
				<div class="kkb-menu-download-style-link-wrap">
					<a target="_blank" rel="noopener" href="https://memberlux.online/redirect-download-king-kit-blocks">Библиотека блоков</a>
				</div>

				<div class="kkb-menu-support-link-wrap">
					<a target="_blank" rel="noopener" href="https://memberlux.online/tg-super-style-mbl">Телеграм-чат</a>
				</div>

				<div class="kkb-menu-author-link-wrap">
					<a target="_blank" rel="noopener" href="https://memberlux.online/tg-igor-lokhman">Написать Игорю</a>
				</div>
				
				<div class="kkb-menu-lesson-link-wrap">
					<a class="kkb-lesson-button">Урок</a>
				</div>
				<!-- <div class="kkb-menu-admin-avatar-wrap"></div> -->
			</div>
		</div>
		
		<!-- Главная обёртка -->
		
		<div class="kkb-wrap">
		
			<!-- СЕКЦИЯ - ИМЯ АРХИВА -->
			
			<div class="kkb-section">
			
				<div class="kkb-user-name-export-file">
					<h2>1. Задайте своё имя для архива</h2>
					<p class="kkb-user-name-desc">Это необязательно. По умолчанию используется имя <span class="kkb-user-file-name-default">«kkb-export-[дата].zip»</span>.</p>
					<input type="text" id="kkb-export-filename" placeholder="Введите имя архива">
				</div>
			
			</div>
			
			<!-- ВЫБОР И ЭКСПОРТ ФАЙЛОВ -->
			
			<div class="kkb-section">
			
				<div class="kkb-preview-and-export-wrap">
					<h2>2. Выберите и экспортируйте файлы блоков и настроек</h2>
					<p class="kkb-desc-export">Выбранные файлы сохранятся в архиве на вашем компьютере.</p>

					<div class="kkb-export-button-wrap">
						<button class="kkb-export-preview-button kkb-medium-btn kkb-secondary-btn kkb-btn" id="kkb-export-preview-button">Выбрать файлы</button>
						<button class="kkb-export-button kkb-medium-btn kkb-primary-btn kkb-btn" id="kkb-export-button">Экспортировать файлы</button>
					</div>
					<div id="kkb-export-status"></div>
				</div>
			
			</div>
			
			<!-- Модальное окно -->

			<div id="kkb-export-preview-modal" class="kkb-export-preview-modal">
				<div class="kkb-export-content">
					<div class="kkb-export-modal-close-wrap">
						<span class="kkb-export-modal-close"></span>
					</div>
					<div id="kkb-preview-file-list">
					<!-- генерация содержания и чекбоксов css и json в kkb-files-export.js -->
					</div>
				</div>
			</div>
			
			<!-- ПОП-АП С ВИДЕОУРОКОМ ПО ПРЕОБРАЖАТОРУ -->

			<div class="kkb-video-lesson-content-wrap" style="display: none;">
				<div class="kkb-video-lesson-content-window">
					<div class="kkb-video-player-wrap">
					<iframe src="https://player.vimeo.com/video/1102403720?badge=0&amp;autopause=0&amp;player_id=0&amp;app_id=58479" frameborder="0" allow="autoplay; fullscreen; picture-in-picture; clipboard-write; encrypted-media" style="position:absolute;top:0;left:0;width:100%;height:100%;" title="Царский набор рубрик 2.0 - большой обзор"></iframe>
					</div>
					<script src="https://player.vimeo.com/api/player.js"></script>
				</div>
			</div>
			
			<!-- ПРЕЛОАДЕР -->

			<div id="kkb-preloader" style="display: none;">
				<div id="kkb-preloader-content">
					<img src="<?php echo plugins_url('assets/icons/kkb-preloader.svg', dirname(__FILE__)); ?>" alt="Загрузка...">
				</div>
			</div>
		
		</div>
		
		<!--  ПОДВАЛ -->
		
		<div class="kkb-footer-wrap">
			<p class="kkb-plugin-title">Царский набор рубрик<span class="kkb-version"> (версия 2.0)</span></p>
			<p>© Игорь Лохман, 2025. Все права, надеюсь, защищены</p>
			<p class="kkb-footer-links"><a class="kkb-king-kit-link" target="_blank" rel="noopener" href="https://memberlux.online/redirect-king-kit">Презентация Царского набора</a>
			<a class="kkb-space-kit-link" target="_blank" rel="noopener" href="https://memberlux.online/redirect-space-kit">Космический набор материалов</a><a class="kkb-preobrazhator-link" target="_blank" rel="noopener" href="https://memberlux.online/redirect-land-preobrazhator">Преображатор Мемберлюкса</a></p>
		</div>

    </div>

	<!-- Сообщение подтверждения удаления 
    <div class="kkb-no-export-file-message">
        <p>Выберите файлы для экспорта</p>
    </div>-->
	
    <?php
}