<?php
// Файл: kkb-files-import.php

if (!defined('ABSPATH')) {
    exit; // Защита от прямого доступа
}

// Подключаем CSS и JS для стилей и функционала
function kkb_files_import_enqueue_assets() {
    wp_enqueue_style('kkb-files-import-css', plugins_url('../assets/css/kkb-files-import.css', __FILE__));
    wp_enqueue_script('kkb-files-import-js', plugins_url('../assets/js/kkb-files-import.js', __FILE__), array('jquery'), null, true);

    // Передаём PHP данные в JS
    wp_localize_script('kkb-files-import-js', 'kkbImportData', array(
        'ajaxUrl' => admin_url('admin-ajax.php'),
        'allowedJsonFiles' => ['kkb-active-css.json', 'kkb-active-main-css.json'], // Исключения для JSON
        'additionalFiles' => $GLOBALS['additional_files'], // Глобальный массив
        'checkboxFiles' => $GLOBALS['checkbox_files'],     // Глобальный массив
        'nonce' => wp_create_nonce('kkb-files-import-nonce'),
    ));
}
add_action('admin_enqueue_scripts', 'kkb_files_import_enqueue_assets');

// Обработчик AJAX для импорта файлов
function kkb_files_import_handler() {
    check_ajax_referer('kkb-files-import-nonce', 'nonce');

    if (!isset($_FILES['files']) || empty($_FILES['files'])) {
        wp_send_json_error(array('message' => 'Файлы не были загружены.'));
    }

    $targetDir = WP_CONTENT_DIR . '/kkb-css/';
    $allowedJsonFiles = ['kkb-active-css.json', 'kkb-active-main-css.json'];
    $additionalFiles = $GLOBALS['additional_files'];
    $checkboxFiles = $GLOBALS['checkbox_files'];

    $validFiles = [];
    foreach ($_FILES['files']['name'] as $index => $name) {
        $ext = pathinfo($name, PATHINFO_EXTENSION);

        // Проверка на соответствие CSS из массивов
        if ($ext === 'css') {
            foreach (array_merge($additionalFiles, $checkboxFiles) as $fileInfo) {
                if ($fileInfo['file'] === $name) {
                    $validFiles[] = $name;
                    break;
                }
            }
        }

        // Проверка на соответствие JSON исключений или связи с CSS
        if ($ext === 'json') {
            if (in_array($name, $allowedJsonFiles)) {
                $validFiles[] = $name;
            } else {
                $correspondingCss = str_replace('-vars.json', '.css', $name);
                foreach (array_merge($additionalFiles, $checkboxFiles) as $fileInfo) {
                    if ($fileInfo['file'] === $correspondingCss) {
                        $validFiles[] = $name;
                        break;
                    }
                }
            }
        }
    }

    // Перемещение файлов
    $importedFiles = [];
    foreach ($validFiles as $index => $file) {
        $tempFilePath = $_FILES['files']['tmp_name'][$index];
        $targetFilePath = $targetDir . $file;

        if (move_uploaded_file($tempFilePath, $targetFilePath)) {
            $importedFiles[] = $file;
        }
    }

    wp_send_json_success(array('importedFiles' => $importedFiles));
}
add_action('wp_ajax_kkb_files_import', 'kkb_files_import_handler');

// Функция для отображения страницы настроек плагина
function kkb_files_import_page() {
    ?>
    <div class="kkb-main-wrap kkb-files-import-page">
		
		<!-- Меню -->
		
		<div class="kkb-menu-wrap">
			<div class="kkb-menu-logo">
				<h2>
					<span class="color-accent-2">Царский</span>
					<span class="color-accent-1">набор рубрик</span>
				</h2>
			</div>

			<div class="kkb-menu-links">
				<div class="kkb-menu-download-style-link-wrap">
					<a target="_blank" rel="noopener" href="https://memberlux.online/redirect-download-king-kit-blocks">Библиотека блоков</a>
				</div>

				<div class="kkb-menu-support-link-wrap">
					<a target="_blank" rel="noopener" href="https://memberlux.online/tg-super-style-mbl">Телеграм-чат</a>
				</div>

				<div class="kkb-menu-author-link-wrap">
					<a target="_blank" rel="noopener" href="https://memberlux.online/tg-igor-lokhman">Написать Игорю</a>
				</div>
				
				<div class="kkb-menu-lesson-link-wrap">
					<a class="kkb-lesson-button">Урок</a>
				</div>
				<!-- <div class="kkb-menu-admin-avatar-wrap"></div> -->
			</div>
		</div>
		
		<div class="kkb-wrap">
		
			<!-- СЕКЦИЯ - ИМПОРТ ФАЙЛОВ -->
			
			<div class="kkb-section">
			
				<div class="kkb-select-and-import-wrap">
					<h2>Обновите файлы блоков и файлы настроек (замена)</h2>
					<p class="kkb-desc-import">Этот загрузчик нужен только для обновления уже установленных файлов блоков и их настроек дизайна.</p>

					<div class="kkb-import-area-with-message-wrap">
						<div class="kkb-import-area-wrap"></div>
						
						<div class="kkb-status-import-out">					
							<div class="kkb-status-import-out-icon"></div>
							<div class="kkb-status-import-out-title">Кликните здесь или перетащите сюда файлы блоков и настроек</div>
							<div class="kkb-status-import-out-subtitle">(только форматы <span class="kkb-import-type-file color-accent-2">*.css</span> и <span class="kkb-import-type-file color-accent-1">*.json</span>)</div>					
						</div>
						
						<div class="kkb-status-import-in">
							<div class="kkb-status-import-in-icon"></div>
							<div class="kkb-status-import-in-title">Отпустите мышку</div>
							<div class="kkb-status-import-in-subtitle">После этого отобразится количество выбранных файлов</div>
						</div>
					</div>
					
					<div class="kkb-import-button-wrap">
						<button class="kkb-import-button kkb-icon-in-btn kkb-medium-btn kkb-primary-btn kkb-btn" id="kkb-import-button" disabled>Обновить файлы</button>
						<button class="kkb-reset-import-button kkb-medium-btn kkb-reset-btn kkb-btn" id="kkb-reset-import-button">Сбросить</button>
					</div>

					<div id="kkb-select-import-status" style="display: none;">
						<p>Будет импортировано файлов: <span class="count-selected-files"></span></p>
					</div>

					<div id="kkb-import-status" style="display: none;">
						<p>Вы успешно загрузили и обновили файлы. Надеюсь, вас не заставили.</p>
					</div>
				</div>
			
			</div>

			<!-- Диалоговое окно alert -->

			<div class="kkb-hidden-import-alert-wrap" style="display: none;">
				<div class="kkb-hidden-import-alert">
					<div class="kkb-import-alert-icon"></div>
					<div class="kkb-import-alert-title">
						<h2>Точно уверены?</h2>
					</div>
					<div class="kkb-import-alert-subtitle">
						<p>Существующие файлы будут перезаписаны. Уверены, что хотите импортировать и заменить их на новые?</p>
					</div>
					<div class="kkb-import-alert-buttons-wrap">
						<button class="kkb-no-import-button kkb-medium-btn kkb-reset-btn kkb-btn">Не импортировать</button>
						<button class="kkb-yes-import-button kkb-medium-btn kkb-primary-btn kkb-btn">Да, импортировать</button>
					</div>
				</div>
			</div>
			
			<!-- ПОП-АП С ВИДЕОУРОКОМ ПО ПРЕОБРАЖАТОРУ -->

			<div class="kkb-video-lesson-content-wrap" style="display: none;">
				<div class="kkb-video-lesson-content-window">
					<div class="kkb-video-player-wrap">
					<iframe src="https://player.vimeo.com/video/1102403720?badge=0&amp;autopause=0&amp;player_id=0&amp;app_id=58479" frameborder="0" allow="autoplay; fullscreen; picture-in-picture; clipboard-write; encrypted-media" style="position:absolute;top:0;left:0;width:100%;height:100%;" title="Царский набор рубрик 2.0 - большой обзор"></iframe>
					</div>
					<script src="https://player.vimeo.com/api/player.js"></script>
				</div>
			</div>
			
			<!-- ПРЕЛОАДЕР -->

			<div id="kkb-preloader" style="display: none;">
				<div id="kkb-preloader-content">
					<img src="<?php echo plugins_url('assets/icons/kkb-preloader.svg', dirname(__FILE__)); ?>" alt="Загрузка...">
				</div>
			</div>

		</div>
		
		<!--  ПОДВАЛ -->
		
		<div class="kkb-footer-wrap">
			<p class="kkb-plugin-title">Царский набор рубрик<span class="kkb-version"> (версия 2.0)</span></p>
			<p>© Игорь Лохман, 2025. Все права, надеюсь, защищены</p>
			<p class="kkb-footer-links"><a class="kkb-king-kit-link" target="_blank" rel="noopener" href="https://memberlux.online/redirect-king-kit">Презентация Царского набора</a>
			<a class="kkb-space-kit-link" target="_blank" rel="noopener" href="https://memberlux.online/redirect-space-kit">Космический набор материалов</a><a class="kkb-preobrazhator-link" target="_blank" rel="noopener" href="https://memberlux.online/redirect-land-preobrazhator">Преображатор Мемберлюкса</a></p>
		</div>

    </div>
    <?php
}