<?php

// Функция для отображения страницы настроек плагина
function kkb_plugin_settings_page() {
    ?>
    <div class="kkb-main-wrap kkb-install-page">
        
		<!-- Меню -->
		
		<div class="kkb-menu-wrap">
			<div class="kkb-menu-logo">
				<h2>
					<span class="color-accent-2">Царский</span>
					<span class="color-accent-1">набор рубрик</span>
				</h2>
			</div>

			<div class="kkb-menu-links">
				<div class="kkb-menu-download-style-link-wrap">
					<a target="_blank" rel="noopener" href="https://memberlux.online/redirect-download-king-kit-blocks">Библиотека блоков</a>
				</div>

				<div class="kkb-menu-support-link-wrap">
					<a target="_blank" rel="noopener" href="https://memberlux.online/tg-super-style-mbl">Телеграм-чат</a>
				</div>

				<div class="kkb-menu-author-link-wrap">
					<a target="_blank" rel="noopener" href="https://memberlux.online/tg-igor-lokhman">Написать Игорю</a>
				</div>
				
				<div class="kkb-menu-lesson-link-wrap">
					<a class="kkb-lesson-button">Урок</a>
				</div>
				<!-- <div class="kkb-menu-admin-avatar-wrap"></div> -->
			</div>
		</div>
		
		<!-- Главная обёртка -->
		
		<div class="kkb-wrap">

			<!-- СЕКЦИЯ - УСТАНОВКА БЛОКОВ -->
			
			<div class="kkb-section kkb-upload-section">
			
				<div class="kkb-upload-section-wrap">
					<h2>1. Установите блоки</h2>
					<p class="kkb-desc-upload">Перетащите сюда свои блоки из «Царского набора» и нажмите кнопку <strong>«Установить»</strong>. Готово :)</p>
					<p class="kkb-desc-upload">Ещё нет красивых блоков? Начните с <strong>Библиотеки блоков</strong>, в которой 81 разновидность дизайна рубрик на любой вкус.</p>
					
					<div class="kkb-upload-area-with-message-wrap">
						<div class="kkb-upload-area-wrap"></div>
						
						<div class="kkb-status-upload-out">
							<div class="kkb-status-upload-out-icon"></div>
							<div class="kkb-status-upload-out-title">Кликните здесь или перетащите сюда файлы блоков</div>
							<div class="kkb-status-upload-out-subtitle">(только формат <span class="kkb-upload-type-file color-accent-2">*.css</span>)</div>	
						</div>
						
						<div class="kkb-status-upload-in">
							<div class="kkb-status-upload-in-icon"></div>
							<div class="kkb-status-upload-in-title">Отпустите мышку</div>
							<div class="kkb-status-upload-in-subtitle">После этого появится список выбранных файлов</div>
						</div>
					
					</div>

					<div class="kkb-info-selected-block-wrap">				
						<!-- <span class="icon-awesome-install"></span> -->
						<p class="kkb-block-install">Будут установлены блоки:</p>
						<span id="kkb-block-install-list-name"></span>
						
						<!-- <span class="icon-awesome-exist"></span> -->
						<p class="kkb-block-exist">Уже установлены блоки:</p>
						<span id="kkb-block-exist-list-name"></span>
						
						<!-- <span class="icon-awesome-error"></span> -->
						<p class="kkb-block-error">Исключены файлы:</p>
						<span id="kkb-block-error-list-name"></span>
					</div>

					<div class="kkb-upload-and-reset-button-wrap">
						<button class="kkb-upload-button kkb-icon-in-btn kkb-medium-btn kkb-primary-btn kkb-btn">Установить</button>
						<button class="kkb-reset-button kkb-medium-btn kkb-reset-btn kkb-btn">Сбросить</button>
					</div>
				</div>

			</div>
				
			<!-- СЕКЦИЯ - КОЛИЧЕСТВО КАРТОЧЕК -->
				
			<div class="kkb-section kkb-classic-card-section">

				<div class="kkb-classic-card-section-wrap">
					<h2>2. Выберите количество классических карточек в ряду</h2>
					<p class="kkb-description-classic-card-options">Так будут выглядеть все рубрики (папки) школы, для которых не задан продвинутый блок.</p>
					
					<div class="kkb-options-main-files-missing">
						<p class="kkb-options-main-files-missing-message">Внимание: загрузите 5 обязательных файлов, чтобы папки превратились в карточки</p>
					</div>
					
					<div class="kkb-number-cards-row-wrap">
						
						<label class="kkb-radio-and-label" for="folder-to-card-3">
							<input name="folder-to-card" type="radio" id="folder-to-card-3" value="folder-to-card-3">
							<label for="folder-to-card-3"></label>
							<span class="kkb-radio-title">3 в ряд - крупные</span>
						</label>
						
						<label class="kkb-radio-and-label" for="folder-to-card-4">
							<input name="folder-to-card" type="radio" id="folder-to-card-4" value="folder-to-card-4">
							<label for="folder-to-card-4"></label>
							<span class="kkb-radio-title">4 в ряд - средние</span>
						</label>
						
						<label class="kkb-radio-and-label" for="folder-to-card-5">
							<input name="folder-to-card" type="radio" id="folder-to-card-5" value="folder-to-card-5">
							<label for="folder-to-card-5"></label>
							<span class="kkb-radio-title">5 в ряд - мелкие</span>
						</label>
						
					</div>

				</div>
				
			</div>
				
			<!-- СЕКЦИЯ - АКТИВАЦИЯ -->

			<div class="kkb-section kkb-activate-section">

				<div class="kkb-activate-section-wrap">
					<h2>3. Активируйте продвинутые блоки</h2>
					<p class="kkb-description-activate-section">К вашей школе автоматически подключатся только необходимые стили.</p>
					
					<div class="kkb-activate-checkbox-empty">
						<p class="kkb-activate-checkbox-empty-message">Вы пока не установили ни одного продвинутого блока</p>
					</div>
					
					<div class="kkb-activate-checkbox-buttons">
						<button type="button" class="kkb-activate-all-checkbox kkb-medium-btn kkb-primary-btn kkb-btn" id="kkb-activate-all">Выбрать всё</button>
						<button type="button" class="kkb-deactivate-all-checkbox kkb-medium-btn kkb-reset-btn kkb-btn" id="kkb-deactivate-all">Сбросить всё</button>
					</div>
					
					<div class="kkb-block-checkbox-list-wrap">
						<!-- Здесь динамически создаются чекбоксы -->
					</div>
				</div>

				<!-- Сохранение настроек -->
				<div class="kkb-save-options-wrap">
					<button class="kkb-save-options-button kkb-big-btn kkb-primary-btn kkb-btn">Сохранить настройки</button>
				</div>
				
			</div>
			
			<!-- ПОП-АП С ВИДЕОУРОКОМ ПО ПРЕОБРАЖАТОРУ -->

			<div class="kkb-video-lesson-content-wrap" style="display: none;">
				<div class="kkb-video-lesson-content-window">
					<div class="kkb-video-player-wrap">
					<iframe src="https://player.vimeo.com/video/1102403720?badge=0&amp;autopause=0&amp;player_id=0&amp;app_id=58479" frameborder="0" allow="autoplay; fullscreen; picture-in-picture; clipboard-write; encrypted-media" style="position:absolute;top:0;left:0;width:100%;height:100%;" title="Царский набор рубрик 2.0 - большой обзор"></iframe>
					</div>
					<script src="https://player.vimeo.com/api/player.js"></script>
				</div>
			</div>
			
			<!-- ПРЕЛОАДЕР -->

			<div id="kkb-preloader" style="display: none;">
				<div id="kkb-preloader-content">
					<img src="<?php echo plugins_url('assets/icons/kkb-preloader.svg', dirname(__FILE__)); ?>" alt="Загрузка...">
				</div>
			</div>

		</div>
		
		<!--  ПОДВАЛ -->
		
		<div class="kkb-footer-wrap">
			<p class="kkb-plugin-title">Царский набор рубрик<span class="kkb-version"> (версия 2.0)</span></p>
			<p>© Игорь Лохман, 2025. Все права, надеюсь, защищены</p>
			<p class="kkb-footer-links"><a class="kkb-king-kit-link" target="_blank" rel="noopener" href="https://memberlux.online/redirect-king-kit">Презентация Царского набора</a>
			<a class="kkb-space-kit-link" target="_blank" rel="noopener" href="https://memberlux.online/redirect-space-kit">Космический набор материалов</a><a class="kkb-preobrazhator-link" target="_blank" rel="noopener" href="https://memberlux.online/redirect-land-preobrazhator">Преображатор Мемберлюкса</a></p>
		</div>
		
    </div>

    <?php
}

// Обработчик Ajax для проверки наличия основных css-файлов в массиве $additional_files

add_action('wp_ajax_check_css_files', 'kkb_check_css_files');
function kkb_check_css_files() {
    global $additional_files;
    $css_folder_path = WP_CONTENT_DIR . '/kkb-css/';
    $missing_files = [];

    foreach ($additional_files as $file_info) {
        if (!file_exists($css_folder_path . $file_info['file'])) {
            $missing_files[] = $file_info['file'];
        }
    }

    // Если есть хотя бы один отсутствующий файл, возвращаем их список
    wp_send_json_success(['missingFiles' => $missing_files]);
}