<?php
// Файл: kkb-upload-json.php

// Подключаем AJAX-обработчик и меню администратора
add_action('wp_ajax_kkb_check_and_copy_json_files', 'kkb_check_and_copy_json_files');
add_action('admin_menu', 'kkb_check_json_on_plugin_page');

// Путь к папкам
define('KKB_CSS_PATH', WP_CONTENT_DIR . '/kkb-css/');
define('KKB_JSON_VARS_PATH', plugin_dir_path(__FILE__) . '../start-json-vars/');

// Основная функция для копирования JSON-файлов
function kkb_copy_json_files() {
    // Получение всех CSS и JSON файлов
    $css_files = glob(KKB_CSS_PATH . '*.css');
    $json_files = glob(KKB_JSON_VARS_PATH . '*-vars.json');

    foreach ($css_files as $css_file) {
        $base_name = basename($css_file, '.css');
        $json_file = KKB_JSON_VARS_PATH . $base_name . '-vars.json';

        if (file_exists($json_file) && !file_exists(KKB_CSS_PATH . basename($json_file))) {
            copy($json_file, KKB_CSS_PATH . basename($json_file));
        }
    }

    // Удаление лишних JSON-файлов, если в папке нет соответствующих CSS-файлов
    /* $existing_json_files = glob(KKB_CSS_PATH . '*-vars.json');
    foreach ($existing_json_files as $json_file) {
        $css_file = KKB_CSS_PATH . str_replace('-vars.json', '.css', basename($json_file));
        if (!file_exists($css_file)) {
            unlink($json_file);
        }
    } */
}

// Функция для копирования JSON-файлов при активации плагина
function kkb_copy_json_files_on_activation() {
    kkb_copy_json_files();
}

// AJAX-обработчик для проверки и копирования JSON-файлов
function kkb_check_and_copy_json_files() {
    kkb_copy_json_files();
    wp_send_json_success(['message' => 'Файлы проверены и скопированы']);
}

// Выполнение проверки JSON при входе на страницу настроек плагина
function kkb_check_json_on_plugin_page() {
    if (isset($_GET['page']) && $_GET['page'] === 'kkb-settings') {
        kkb_copy_json_files();
    }
}