jQuery(document).ready(function ($) {
    const checkboxContainer = $('.kkb-block-checkbox-list-wrap');
    const filesToCheck = kkbCheckboxOptions.checkboxFiles.map(fileObj => fileObj.file);
    const cssFolderPath = `${window.location.origin}/wp-content/kkb-css/`;

    // Проверяем наличие чекбоксов и скрываем/показываем элементы
    function updateCheckboxVisibility() {
        const hasCheckboxes = $('.kkb-block-checkbox-list-wrap .checkbox-and-label').length > 0;

        // Показываем/скрываем пустое сообщение
        $('.kkb-activate-checkbox-empty').toggle(!hasCheckboxes);

        // Показываем/скрываем кнопки
        $('.kkb-activate-checkbox-buttons').toggle(hasCheckboxes);
    }

    // Обновляем видимость элементов при загрузке и после генерации чекбоксов
    function onCheckboxesGenerated() {
        updateCheckboxVisibility();
        applySavedConfiguration(); // Сохраняем существующую логику
    }

    // Вызываем updateCheckboxVisibility при загрузке страницы
    updateCheckboxVisibility();

    // Обработчики для кнопок "Выбрать всё" и "Сбросить всё"
    $('#kkb-activate-all').on('click', function () {
        $('.kkb-block-checkbox-list-wrap .kkb-css-checkbox').prop('checked', true).trigger('change');
    });

    $('#kkb-deactivate-all').on('click', function () {
        $('.kkb-block-checkbox-list-wrap .kkb-css-checkbox').prop('checked', false).trigger('change');
    });

    // Проверка наличия файлов и генерация чекбоксов
    $.ajax({
        url: ajaxurl,
        method: 'POST',
        dataType: 'json',
        data: {
            action: 'kkb_check_checkbox_files_exist',
            files: filesToCheck
        },
        success: function (response) {
            if (response.success && response.data.exists) {
                generateCheckboxes(response.data.exists);
            } else {
                console.warn("Файлы для чекбоксов не найдены.");
            }
        },
        error: function (xhr, status, error) {
            console.error("Ошибка AJAX запроса:", error);
        }
    });

    function generateCheckboxes(existingFiles) {
        const matchingFiles = kkbCheckboxOptions.checkboxFiles.filter(fileObj => existingFiles.includes(fileObj.file));

        // Сортируем matchingFiles по "человеческому" названию (label или block)
        matchingFiles.sort((a, b) => {
            const labelA = a.block || a.label || ''; // Если block нет, используем label
            const labelB = b.block || b.label || ''; 
            return labelA.localeCompare(labelB, 'ru', { sensitivity: 'base' });
        });

        // Определяем количество элементов в каждом столбце
        const columnCount = 3; // Количество столбцов
        const itemsPerColumn = Math.ceil(matchingFiles.length / columnCount); // Равномерное распределение
        let columns = Array.from({ length: columnCount }, () => []);

        // Заполняем столбцы по очереди, сохраняя общий алфавитный порядок
        matchingFiles.forEach((fileObj, index) => {
            const fileId = fileObj.file.replace('.css', '');
            const blockLabel = fileObj.block || fileObj.label;

            // Оборачиваем чекбокс и метку в <div class="checkbox-and-label">
            const checkboxHtml = `
                <div class="checkbox-and-label">
                    <input type="checkbox" id="${fileId}" value="${fileId}" class="kkb-css-checkbox">
                    <label for="${fileId}">${blockLabel}</label>
                </div>
            `;

            // Распределяем по столбцам
            const columnIndex = Math.floor(index / itemsPerColumn);
            columns[columnIndex].push(checkboxHtml);
        });

        // Генерируем HTML для каждого столбца и добавляем в контейнер
        columns.forEach((column, index) => {
            const columnHtml = `<div class="kkb-checkbox-column">${column.join('')}</div>`;
            checkboxContainer.append(columnHtml);
			
			// Добавляем <div class="kkb-column-separator"> после каждого столбца, кроме последнего
			if (index < columns.length - 1) {
				checkboxContainer.append('<div class="kkb-column-separator"></div>');
			}
        });

        // Вызываем обновление видимости после генерации чекбоксов
        onCheckboxesGenerated();
    }

    // Применение сохранённых значений из JSON
    function applySavedConfiguration() {
        $.ajax({
            url: ajaxurl,
            method: 'POST',
            dataType: 'json',
            data: { action: 'kkb_load_active_css' },
            success: function (response) {
                if (response.success && response.data.activeFiles) {
                    response.data.activeFiles.forEach(fileId => {
                        $(`#${fileId}`).prop('checked', true);
                        addCSSLink(fileId);
                    });
                }
            }
        });
    }

    // Добавляем CSS-файл в head
    function addCSSLink(fileId) {
        if (!$(`link[data-file-id="${fileId}"]`).length) {
            const linkTag = `<link rel="stylesheet" type="text/css" media="all" href="${cssFolderPath}${fileId}.css" data-file-id="${fileId}">`;
            $('head').append(linkTag);
        }
    }

    // Удаляем CSS-файл из head
    function removeCSSLink(fileId) {
        $(`link[data-file-id="${fileId}"]`).remove();
    }

    // Обработчик изменения состояния чекбоксов
    $(document).on('change', '.kkb-css-checkbox', function () {
        const fileId = $(this).val();
        if ($(this).is(':checked')) {
            addCSSLink(fileId);
        } else {
            removeCSSLink(fileId);
        }
    });

    // Сохранение состояния чекбоксов в JSON по нажатию кнопки
    $('.kkb-save-options-button').on('click', function () {
        const activeFiles = $('.kkb-css-checkbox:checked').map(function () {
            return $(this).val();
        }).get();

        $.ajax({
            url: ajaxurl,
            method: 'POST',
            dataType: 'json',
            data: {
                action: 'kkb_save_active_css',
                activeFiles: activeFiles
            },
            success: function (response) {
                window.handleSaveCompletion(response.success);
            },
            error: function () {
                window.handleSaveCompletion(false);
            }
        });
    });
});