var fileMissingDisplayed = false; // Флаг для отслеживания состояния отображения элемента
var mainFileMissingDisplayed = false; // Флаг для отслеживания состояния отображения основного файла

function updateSlug() {
    var select = document.getElementById('slug-options');
    var selectedValue = select.options[select.selectedIndex].value;

    var slugInput = document.getElementById('slug');
    var currentSlug = slugInput.value;

    var options = Array.from(select.options).map(option => option.value);
    options.forEach(option => {
        if (currentSlug.startsWith(option)) {
            slugInput.value = currentSlug.replace(option, ''); // Убираем совпадение
        }
    });

    if (selectedValue) {
        slugInput.value = selectedValue + slugInput.value;

        for (var key in window.optionsFiles) {
            if (!window.optionsFiles[key].fileExists && currentSlug.startsWith(key)) {
                slugInput.value = slugInput.value.replace(key, ''); // Удаляем отсутствующий файл
            }
        }
    }

    updateMissingFileWarning(); // Обновляем состояние предупреждения
    updateImagePreview(selectedValue); // Обновляем изображение
}

function updateMissingFileWarning() {
    var slugInput = document.getElementById('slug');
    var missingFileSpan = document.querySelector('.current-block-file-missing');
    var slugValue = slugInput ? slugInput.value : '';

    for (var key in window.optionsFiles) {
        if (slugValue.startsWith(key)) {
            if (!window.optionsFiles[key].fileExists) {
                if (!fileMissingDisplayed) {
                    missingFileSpan.style.display = 'flex';
                    fileMissingDisplayed = true; // Фиксируем, что предупреждение было показано
                }
            }
            return; // Прекратить проверку после нахождения совпадения
        }
    }
}

function updateMainFileMissingWarning() {
    var mainFileMissingP = document.querySelector('.main-file-missing');

    // Проверяем наличие всех файлов, учитывая новую структуру
    var hasAllAdditionalFiles = window.additionalFiles.every(fileData => fileData.fileExists);

    if (!hasAllAdditionalFiles) {
        if (!mainFileMissingDisplayed) {
            mainFileMissingP.style.display = 'flex';
            mainFileMissingDisplayed = true;
        }
    } else {
        mainFileMissingP.style.display = 'none';
        mainFileMissingDisplayed = false;
    }
}

document.addEventListener('DOMContentLoaded', function () {
    updateMissingFileWarning();
    updateMainFileMissingWarning();
    setInitialDesign();
    selectMatchingOption(); // Вызываем функцию для предварительного выбора опции

    // Вызов обновления картинки для первой пустой опции при загрузке страницы
    var select = document.getElementById('slug-options');
    var selectedValue = select.options[select.selectedIndex].value;
    updateImagePreview(selectedValue); // Установить превью для пустой опции

    // Обновляем состояние чекбоксов при загрузке страницы
    updateCheckboxStates();

    // Привязываем обработчики для чекбоксов
    document.getElementById('off-block').addEventListener('change', function() {
        handleCheckboxChange('off-block', 'off-');
    });

    document.getElementById('move-to-right-block').addEventListener('change', function() {
        handleCheckboxChange('move-to-right-block', 'move-to-right-');
    });
});

function setInitialDesign() {
    var slugInput = document.getElementById('slug');
    var currentDesignSpan = document.querySelector('.name-current-block-design');
    var slugValue = slugInput ? slugInput.value : '';

    /* for (var key in window.optionsFiles) {
        if (slugValue.startsWith(key)) {
            currentDesignSpan.textContent = window.optionsFiles[key].label; // Устанавливаем текст из label
            return; // Выходим из функции, если нашли совпадение
        }
    } */
	
	// Получаем все ключи и сортируем по длине (от самых длинных к самым коротким)
    var keys = Object.keys(window.optionsFiles).sort(function(a, b) {
        return b.length - a.length;
    });

    for (var i = 0; i < keys.length; i++) {
        var key = keys[i];
        if (slugValue.startsWith(key)) {
            currentDesignSpan.textContent = window.optionsFiles[key].label;
            return;
        }
    }
    
    currentDesignSpan.textContent = 'Классическая карточка';
}

// Функция для обновления изображения в зависимости от выбранной опции
function updateImagePreview(selectedValue) {
    var imagePreview = document.getElementById('image-preview');
    
    // Если выбрана пустая опция
    if (!selectedValue) {
        imagePreview.src = window.pluginsUrl + 'assets/images/preview/preview-empty.png'; // Показываем пустую картинку
        imagePreview.alt = "Empty Preview"; // Обновляем alt текст
        return; // Завершаем выполнение функции
    }

    // Находим соответствующее изображение по выбранной опции
    var selectedOption = window.optionsFiles[selectedValue];
    if (selectedOption && selectedOption.image) {
        imagePreview.src = selectedOption.image; // Устанавливаем src изображения
        imagePreview.alt = selectedOption.label || "Preview"; // Обновляем alt текст
    } else {
        imagePreview.src = window.pluginsUrl + 'assets/images/preview/preview-empty.png'; // Если не найдено, показываем пустую картинку
        imagePreview.alt = "Empty Preview";
    }
}

// Обработка чекбоксов
function handleCheckboxChange(checkboxId, checkboxValue) {
    var slugInput = document.getElementById('slug');
    var currentSlug = slugInput.value;

    // Получаем опции выпадающего списка
    var select = document.getElementById('slug-options');
    var options = Array.from(select.options).map(option => option.value);
    var matchTextFromOption = ''; // Переменная для хранения совпадающего текста

    // Находим совпадение
    options.forEach(option => {
        if (currentSlug.startsWith(option)) {
            matchTextFromOption = option; // Сохраняем совпадающий текст
        }
    });

    if (document.getElementById(checkboxId).checked) {
        // Если есть найденное совпадение, добавляем значение чекбокса после него
        if (matchTextFromOption) {
            slugInput.value = currentSlug.replace(matchTextFromOption, matchTextFromOption + checkboxValue);
        } else {
            // Если совпадений нет, добавляем значение в начало
            slugInput.value = checkboxValue + currentSlug;
        }
    } else {
        // Убираем значение при деактивации чекбокса
        slugInput.value = currentSlug.replace(checkboxValue, ''); // Удаляем значение чекбокса
    }
}

// Обновляем состояние чекбоксов при изменении или загрузке страницы
function updateCheckboxStates() {
    var slugInput = document.getElementById('slug').value;
    var offBlockCheckbox = document.getElementById('off-block');
    var rBlockCheckbox = document.getElementById('move-to-right-block');

    // Для off-block
    if (slugInput.includes(offBlockCheckbox.value)) {
        offBlockCheckbox.checked = true;
    } else {
        offBlockCheckbox.checked = false;
    }

    // Для move-to-right-block
    if (slugInput.includes(rBlockCheckbox.value)) {
        rBlockCheckbox.checked = true;
    } else {
        rBlockCheckbox.checked = false;
    }
}

// Функция для предварительного выбора опции в зависимости от содержимого поля slug
function selectMatchingOption() {
    var slugInput = document.getElementById('slug');
    var select = document.getElementById('slug-options');
    var currentSlug = slugInput.value;
    var options = Array.from(select.options).map(option => option.value);

    var foundMatch = false;

    options.forEach((optionValue, index) => {
        if (currentSlug.startsWith(optionValue)) {
            select.selectedIndex = index; // Устанавливаем выбранную опцию
            foundMatch = true;
        }
    });

    // Если совпадение не найдено, выбираем первую пустую опцию
    if (!foundMatch) {
        select.selectedIndex = 0;
    }
}

var activeCssFiles = []; // Переменная для формирования списка активных блоков в kkb-active-css.json

// Функция для загрузки списка активированных CSS-файлов из kkb-active-css.json
function loadActiveCssFiles() {
    fetch(kkbActiveCssData.jsonUrl)
        .then(response => response.json())
        .then(data => {
            activeCssFiles = data; // Сохраняем список активных css-файлов из JSON
            checkAndToggleActivationWarning(); // Выполняем проверку при загрузке
        })
        .catch(error => console.error('Ошибка при загрузке JSON с активными CSS:', error));
}

// Функция проверки соответствия выбранной опции и активного CSS в JSON
function checkAndToggleActivationWarning() {
    var select = document.getElementById('slug-options');
    var selectedValue = select.options[select.selectedIndex].value;
    var warningBlock = document.querySelector('.block-not-activated');

    // Проверяем, если выбрана опция, и есть соответствующий CSS-файл в JSON
    if (selectedValue && window.optionsFiles[selectedValue]) {
        var selectedCssFile = window.optionsFiles[selectedValue].file.replace('.css', '');
        
        if (!activeCssFiles.includes(selectedCssFile)) {
			// Если CSS-файл не активен, показываем предупреждение
            warningBlock.style.display = 'flex';
        } else {
			// Иначе скрываем предупреждение
            warningBlock.style.display = 'none';
        }
    } else {
        // Если опция не выбрана, скрываем предупреждение
        warningBlock.style.display = 'none';
    }
}

// Привязываем функцию к событию выбора опции и загружаем активные CSS при загрузке страницы
document.addEventListener('DOMContentLoaded', function () {
    loadActiveCssFiles(); // Загружаем активные CSS из JSON при загрузке страницы

    var select = document.getElementById('slug-options');
    select.addEventListener('change', checkAndToggleActivationWarning); // Проверка при изменении опции
});