jQuery(document).ready(function ($) {
    const fadeInSpeed = 300; // Скорость появления (в миллисекундах)
    const fadeOutSpeed = 300; // Скорость скрытия (в миллисекундах)

    let selectedFiles = [];
    const allowedJsonFiles = kkbImportData.allowedJsonFiles;
    const additionalFiles = kkbImportData.additionalFiles.map(f => f.file);
    const checkboxFiles = kkbImportData.checkboxFiles.map(f => f.file);

    const preloader = $("#kkb-preloader");
    const dropArea = $(".kkb-import-area-wrap");
	const statusImportOut = $(".kkb-status-import-out");
    const statusImportIn = $(".kkb-status-import-in");
	
	// Изначально показываем "Перетащите сюда файлы" и скрываем "Отпустите мышку"
    statusImportOut.css("display", "flex");
    statusImportIn.css("display", "none");

    // Функция фильтрации подходящих файлов
    function filterValidFiles(files) {
        return files.filter(file => {
            const ext = file.name.split('.').pop().toLowerCase();
            if (ext === 'css') {
                return additionalFiles.includes(file.name) || checkboxFiles.includes(file.name);
            }
            if (ext === 'json') {
                const cssName = file.name.replace('-vars.json', '.css');
                return (
                    allowedJsonFiles.includes(file.name) ||
                    additionalFiles.includes(cssName) ||
                    checkboxFiles.includes(cssName)
                );
            }
            return false;
        });
    }

    // Обновление числа выбранных файлов
    function updateFileCount() {
        const validFiles = filterValidFiles(selectedFiles);
        if (validFiles.length > 0) {
            $("#kkb-select-import-status").show();
            $(".count-selected-files").text(validFiles.length);
            $("#kkb-import-button").prop("disabled", false);
        } else {
            $("#kkb-select-import-status").hide();
            $(".count-selected-files").text(0);
            $("#kkb-import-button").prop("disabled", true);
        }
    }

    // Открытие проводника по клику
    dropArea.on("click", function () {
        $("<input type='file' multiple accept='.css,.json'>")
            .on("change", function (e) {
                selectedFiles = Array.from(e.target.files);
                updateFileCount();
            })
            .click();
    });

    // Drag-and-Drop
    dropArea.on("dragenter", function (e) {
        e.preventDefault();
        e.stopPropagation();
        dropArea.addClass("dragover"); // Добавляем класс для визуального выделения
        statusImportOut.css("display", "none"); // Скрываем "Перетащите сюда файлы"
        statusImportIn.css("display", "flex"); // Показываем "Отпустите мышку"
    });
	
	dropArea.on("dragover", function (e) {
        e.preventDefault();
        e.stopPropagation();
        dropArea.addClass("dragover"); // Убедимся, что класс остаётся
    });

    dropArea.on("dragleave", function (e) {
        e.preventDefault();
        e.stopPropagation();
        dropArea.removeClass("dragover"); // Убираем класс
        statusImportOut.css("display", "flex"); // Показываем "Перетащите сюда файлы"
        statusImportIn.css("display", "none"); // Скрываем "Отпустите мышку"
    });

    dropArea.on("drop", function (e) {
        e.preventDefault();
        e.stopPropagation();
        dropArea.removeClass("dragover"); // Убираем класс
        statusImportOut.css("display", "flex"); // Возвращаем "Перетащите сюда файлы"
        statusImportIn.css("display", "none"); // Скрываем "Отпустите мышку"
        const droppedFiles = Array.from(e.originalEvent.dataTransfer.files);
        selectedFiles = droppedFiles; // Сохраняем выбранные файлы
        updateFileCount();
    });

    // Сброс выбранных файлов
    $("#kkb-reset-import-button").on("click", function () {
        selectedFiles = [];
        updateFileCount();
    });

    // Открытие окна подтверждения импорта
    $("#kkb-import-button").on("click", function () {
        $(".kkb-hidden-import-alert-wrap").fadeIn(fadeInSpeed);
    });

    // Импорт файлов
    $(".kkb-yes-import-button").on("click", function () {
        $(".kkb-hidden-import-alert-wrap").fadeOut(fadeOutSpeed); // Скрываем окно
        preloader.fadeIn(); // Показываем прелоадер

        const formData = new FormData();
        const validFiles = filterValidFiles(selectedFiles);
        validFiles.forEach(file => formData.append("files[]", file));
        formData.append("action", "kkb_files_import");
        formData.append("nonce", kkbImportData.nonce);

        $.ajax({
            url: kkbImportData.ajaxUrl,
            method: "POST",
            data: formData,
            processData: false,
            contentType: false,
            success: function (response) {
                if (response.success) {
                    $("#kkb-import-status").show();
                } else {
                    alert("Ошибка: " + response.data.message);
                }
            },
            error: function () {
                alert("Произошла ошибка при импорте.");
            },
            complete: function () {
                preloader.fadeOut();
                selectedFiles = [];
                updateFileCount();
            }
        });
    });

    // Отмена импорта
    $(".kkb-no-import-button").on("click", function () {
        $(".kkb-hidden-import-alert-wrap").fadeOut(fadeOutSpeed);
    });
});