// Общая функция для обработки завершения сохранения всех настроек при нажатии на кнопку
document.addEventListener('DOMContentLoaded', function () {
    const preloader = document.getElementById('kkb-preloader'); // Прелоадер
    let saveCompletionCount = 0; // Счетчик завершенных сохранений

    function togglePreloader(show) {
        if (preloader) {
            preloader.style.display = show ? 'flex' : 'none';
        }
    }

    function handleSaveCompletion(success) {
        if (success) {
            saveCompletionCount++;
            if (saveCompletionCount === 2) {  // Условие для показа сообщения только после двух успешных сохранений
                togglePreloader(false); // Скрываем прелоадер
                location.reload(); // Перезагрузка страницы вместо alert
            }
        } else {
            togglePreloader(false); // Скрываем прелоадер в случае ошибки
            alert('Ошибка при сохранении настроек. Проверьте консоль для подробностей.');
            saveCompletionCount = 0; // Сбросить счетчик в случае ошибки
        }
    }

    window.handleSaveCompletion = handleSaveCompletion; // Делаем функцию глобальной

    // Добавляем обработчик клика для кнопки сохранения
    const saveButton = document.querySelector('.kkb-save-options-button');
    if (saveButton) {
        saveButton.addEventListener('click', function () {
            togglePreloader(true); // Показываем прелоадер при нажатии кнопки
            saveCompletionCount = 0; // Сбрасываем счетчик перед началом сохранения
        });
    }
});