<?php
// Файл: kkb-design-settings.php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Защита от прямого доступа
}

// Подключаем стили и скрипты Coloris и JavaScript для страницы настроек
function kkb_enqueue_coloris_assets() {
    // Путь к папке плагина
    $plugin_url = plugin_dir_url(__FILE__);

    // Подключаем CSS
    wp_enqueue_style('coloris-css', $plugin_url . '../assets/coloris-0.24.0/dist/coloris.min.css');

    // Подключаем JS для Coloris
    wp_enqueue_script('coloris-js', $plugin_url . '../assets/coloris-0.24.0/dist/coloris.min.js', array(), null, true);

    // Инициализация Coloris после загрузки страницы
    wp_add_inline_script('coloris-js', 'Coloris({
        el: ".color-field", 
        alpha: true, 
        wrap: true, 
        themeMode: "light", 
        formatToggle: true, 
        theme: "polaroid", 
        swatches: [
            "#264653",
            "#2a9d8f",
            "#e9c46a",
            "rgb(244,162,97)",
            "#e76f51",
            "#d62828",
            "navy",
            "#07b",
            "#0096c7",
            "#00b4d880",
            "rgba(0,119,182,0.8)"
        ]
    });');
}

// Подключаем функцию на страницу админки, где нужны Coloris
add_action('admin_enqueue_scripts', 'kkb_enqueue_coloris_assets');

// Функция для получения соответствующих опций для выпадающего меню с группировкой
function kkb_get_design_options() {
    // Подключаем массивы из файла kkb-edit-cat-options.php
    global $checkbox_files, $additional_files;

    // Папка с css и json файлами
    $css_folder = WP_CONTENT_DIR . '/kkb-css/';

    // Получаем список всех json-файлов в папке
    $json_files = glob( $css_folder . '*-vars.json' );

    // Массив для группировки опций
    $grouped_options = [];

    // Объединяем файлы из массивов $checkbox_files и $additional_files
    $all_files = array_merge($checkbox_files, $additional_files);

    // Перебираем все json-файлы, находим для них css-файлы и формируем список опций с группировкой
    foreach ($json_files as $json_file) {
		// Извлекаем имя json-файла (без пути и расширения)
        $json_filename = basename($json_file, '.json');
        $corresponding_css_filename = str_replace('-vars', '', $json_filename) . '.css';

        // Поиск соответствующего CSS-файла в объединенном массиве
        foreach ($all_files as $file_info) {
            if ($file_info['file'] === $corresponding_css_filename) {
                $label = $file_info['block'] ?? $file_info['label'] ?? $json_filename; // Заголовок для опции
                $group = $file_info['group'] ?? 'Без группы'; // Группа или "Без группы"

                // Добавляем в массив групп
                $grouped_options[$group][] = [
                    'value' => $json_filename,
                    'label' => $label,
                ];
                break;
            }
        }
    }

    return $grouped_options;
}

// Функция для отображения страницы настроек дизайна
function kkb_design_settings_page() { 
    // Получаем все опции для выпадающего списка с группировкой
    $grouped_options = kkb_get_design_options();
    ?>
    
    <div class="kkb-main-wrap kkb-design-settings-page">
        
		<!-- Меню -->
		
		<div class="kkb-menu-wrap">
			<div class="kkb-menu-logo">
				<h2>
					<span class="color-accent-2">Царский 2.0</span>
					<span class="logo-sup">Lite</span>
					<!--<span class="color-accent-1">набор рубрик</span>-->
					<!--<sup class="logo-sup">Lite</sup>-->
				</h2>
			</div>

			<div class="kkb-menu-links">
				<div class="kkb-menu-download-style-link-wrap">
					<a target="_blank" rel="noopener" href="https://memberlux.online/redirect-download-king-kit-blocks">Библиотека блоков</a>
				</div>

				<div class="kkb-menu-support-link-wrap">
					<a target="_blank" rel="noopener" href="https://memberlux.online/tg-super-style-mbl">Телеграм-чат</a>
				</div>

				<div class="kkb-menu-author-link-wrap">
					<a target="_blank" rel="noopener" href="https://memberlux.online/tg-igor-lokhman">Написать Игорю</a>
				</div>
				
				<div class="kkb-menu-lesson-link-wrap">
					<a class="kkb-lesson-button">Урок</a>
				</div>
				<!-- <div class="kkb-menu-admin-avatar-wrap"></div> -->
			</div>
		</div>
        
		<!-- Секция выбора блока, кнопки и предупреждения -->
			
		<div class="kkb-select-section">
			
			<!-- Блок выбора блока и кнопки -->
			
			<div class="kkb-select-and-buttons-wrap">	
			
				<!-- Блок выпадающего списка блоков -->
				
				<div class="kkb-select-wrap">
					<h2>Выберите блок</h2>

					<select id="design-options" name="design-options">
						<option value="">Выберите блок</option>
						<?php foreach ($grouped_options as $group_label => $options): ?>
							<optgroup label="<?= htmlspecialchars($group_label) ?>">
								<?php foreach ($options as $option): ?>
									<option value="<?= htmlspecialchars($option['value']) ?>"><?= htmlspecialchars($option['label']) ?></option>
								<?php endforeach; ?>
							</optgroup>
						<?php endforeach; ?>
					</select>
					
				</div>

				<!-- Блок с кнопками -->
				
				<div class="kkb-buttons-wrap">
					<button class="kkb-save-design-settings-button kkb-big-btn kkb-primary-btn kkb-btn">Сохранить</button>
					<button class="kkb-reset-design-settings-button kkb-big-btn kkb-reset-btn kkb-btn">Сбросить</button>
				</div>
			</div>
				
			<!-- Блок предупреждения -->
			
			<div class="kkb-warning-css-missing-wrap">
				<p class="kkb-warning-css-missing-message">Внимание: для выбранных настроек дизайна отсутствует css-файл. Установите его</p>
			</div>
			
		</div>
		
		<!-- Секция переменных для выбранного блока -->
		
		<div class="var-section-wrap">
			<!-- Генерация настроек с переменными -->
		</div>
		
		<!--  ПОДВАЛ -->
		
		<div class="kkb-footer-wrap">
			<p class="kkb-plugin-title">Царский набор рубрик<span class="kkb-version"> (версия 2.0 LITE)</span></p>
			<p>© Игорь Лохман, 2025. Все права, надеюсь, защищены</p>
			<p class="kkb-footer-links"><a class="kkb-king-kit-link" target="_blank" rel="noopener" href="https://memberlux.online/redirect-king-kit">Презентация Царского набора</a>
			<a class="kkb-space-kit-link" target="_blank" rel="noopener" href="https://memberlux.online/redirect-space-kit">Космический набор материалов</a><a class="kkb-preobrazhator-link" target="_blank" rel="noopener" href="https://memberlux.online/redirect-land-preobrazhator">Преображатор Мемберлюкса</a></p>
		</div>
		
		<!-- ПОП-АП С ВИДЕОУРОКОМ ПО ПРЕОБРАЖАТОРУ -->

		<div class="kkb-video-lesson-content-wrap" style="display: none;">
			<div class="kkb-video-lesson-content-window">
				<div class="kkb-video-player-wrap">
				<iframe src="https://player.vimeo.com/video/1102403720?badge=0&amp;autopause=0&amp;player_id=0&amp;app_id=58479" frameborder="0" allow="autoplay; fullscreen; picture-in-picture; clipboard-write; encrypted-media" style="position:absolute;top:0;left:0;width:100%;height:100%;" title="Царский набор рубрик 2.0 - большой обзор"></iframe>
				</div>
				<script src="https://player.vimeo.com/api/player.js"></script>
			</div>
		</div>
		
    </div>
    
    <!-- ПРЕЛОАДЕР -->
	
    <div id="kkb-preloader" style="display: none;">
        <div id="kkb-preloader-content">
            <img src="<?php echo plugins_url('assets/icons/kkb-preloader.svg', dirname(__FILE__)); ?>" alt="Загрузка...">
        </div>
    </div>

<?php }

// Обработчики Ajax для сохранения и сброса
add_action('wp_ajax_kkb_save_design_settings', 'kkb_save_design_settings');
function kkb_save_design_settings() {
    if (empty($_POST['file']) || empty($_POST['data'])) {
        wp_send_json_error(['message' => 'Файл или данные отсутствуют']);
        return;
    }

    $file = sanitize_text_field($_POST['file']);
    $new_data = json_decode(stripslashes($_POST['data']), true);
    $file_path = WP_CONTENT_DIR . '/kkb-css/' . $file . '.json';

    if (file_exists($file_path)) {
		// Загружаем текущий JSON-файл
        $original_data = json_decode(file_get_contents($file_path), true);
        if (!$original_data) {
            wp_send_json_error(['message' => 'Не удалось загрузить исходные данные']);
            return;
        }

		// Обновляем только значения `value` в существующей структуре
        foreach ($new_data as $key => $value_data) {
            if (isset($original_data[$key])) {
                $original_data[$key]['value'] = $value_data['value'];
            }
        }

		// Сохраняем обновленный JSON-файл
        file_put_contents($file_path, json_encode($original_data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        wp_send_json_success(['message' => 'Настройки сохранены']);
    } else {
        wp_send_json_error(['message' => 'Файл не найден']);
    }
}

add_action('wp_ajax_kkb_reset_design_settings', 'kkb_reset_design_settings');
function kkb_reset_design_settings() {
    if (empty($_POST['file'])) {
        wp_send_json_error(['message' => 'Файл отсутствует']);
        return;
    }

    $file = sanitize_text_field($_POST['file']);
    $start_file_path = plugin_dir_path(__FILE__) . '../start-json-vars/' . $file . '.json';
    $target_file_path = WP_CONTENT_DIR . '/kkb-css/' . $file . '.json';

    if (file_exists($start_file_path)) {
        $default_data = file_get_contents($start_file_path);
        file_put_contents($target_file_path, $default_data);
        wp_send_json_success(['message' => 'Настройки сброшены']);
    } else {
        wp_send_json_error(['message' => 'Файл по умолчанию не найден']);
    }
}

// Новый AJAX-хук: получение JSON-данных по имени файла (без .json)
add_action('wp_ajax_get_kkb_json', 'kkb_get_json_callback');
function kkb_get_json_callback() {
    // Проверяем права: только авторизованный администратор или пользователь с нужными правами
    if ( ! current_user_can('manage_options') ) {
        wp_send_json_error(['message' => 'Недостаточно прав'], 403);
        return;
    }

    // Имя файла передаётся в параметре 'file' (без расширения .json)
    $file = isset($_GET['file']) ? sanitize_file_name($_GET['file']) : '';
    if ( empty($file) ) {
        wp_send_json_error(['message' => 'Не указан параметр file'], 400);
        return;
    }

    // Строим путь к реальному JSON-файлу в /wp-content/kkb-css/
    $json_path = WP_CONTENT_DIR . '/kkb-css/' . $file . '.json';

    if ( ! file_exists($json_path) ) {
        wp_send_json_error(['message' => 'Файл не найден'], 404);
        return;
    }

    // Читаем содержимое файла
    $data = file_get_contents($json_path);
    if ( $data === false ) {
        wp_send_json_error(['message' => 'Не удалось прочитать файл'], 500);
        return;
    }

    // Отдаём «сырое» содержимое JSON и сразу выходим
    header('Content-Type: application/json; charset=UTF-8');
    echo $data;
    wp_die();
}

?>