<?php
// connect-vars.php

function kkb_connect_css_variables() {
    // Папка с CSS и JSON файлами
    $dir = WP_CONTENT_DIR . '/kkb-css/';
    $url_dir = content_url('/kkb-css/');
    
    // Получаем все подключенные CSS файлы в head
    $css_files = [];
    foreach (wp_styles()->registered as $style) {
        if (strpos($style->src, $url_dir) !== false) {
            $css_files[] = basename($style->src, '.css');
        }
    }
    
    // Если нет подключенных CSS файлов, завершить выполнение
    if (empty($css_files)) return;

    // Собираем переменные для подключения
    $css_variables = ':root {' . PHP_EOL;

    foreach ($css_files as $css_file) {
        $json_file_path = $dir . $css_file . '-vars.json';
        
        // Проверяем наличие соответствующего JSON файла
        if (file_exists($json_file_path)) {
            $json_data = json_decode(file_get_contents($json_file_path), true);
            
            // Если JSON успешно прочитан, обрабатываем каждую переменную
            if ($json_data && is_array($json_data)) {
                foreach ($json_data as $var_name => $attributes) {
                    $value = isset($attributes['value']) ? $attributes['value'] : '';
                    $unit = isset($attributes['unit']) ? $attributes['unit'] : '';
                    
                    // Формируем переменную в зависимости от типа
                    switch ($attributes['type']) {
                        case 'text':
                            // Заменяем двойной слеш на одинарный, чтобы сохранить исходный формат
                            $value = str_replace('\\\\', '\\', $value);
                            $css_variables .= "--$var_name: '$value';" . PHP_EOL;
                            break;
                        case 'url':
                            $css_variables .= "--$var_name: url(\"$value\");" . PHP_EOL;
                            break;
                        default:
                            $css_variables .= "--$var_name: $value$unit;" . PHP_EOL;
                    }
                }
            }
        }
    }

    $css_variables .= '}' . PHP_EOL;

    // Выводим в head <style> с переменными
    echo "<style id='kkb-block-design-css'>$css_variables</style>";
}

// Подключаем функцию к wp_head для вставки переменных в head
add_action('wp_head', 'kkb_connect_css_variables');