<?php
// Файл: kkb-files-delete.php

if (!defined('ABSPATH')) {
    exit; // Защита от прямого доступа
}

// Подключаем CSS для стилей
function kkb_files_delete_enqueue_styles() {
    wp_enqueue_style('kkb-files-delete-css', plugins_url('../assets/css/kkb-files-delete.css', __FILE__));
    wp_enqueue_script('kkb-files-delete-js', plugins_url('../assets/js/kkb-files-delete.js', __FILE__), array('jquery'), null, true);
}
add_action('admin_enqueue_scripts', 'kkb_files_delete_enqueue_styles');

// Функция для отображения страницы удаления css-файлов
function kkb_files_delete_page() {
    global $additional_files, $checkbox_files;

    // Получаем список CSS-файлов в папке
    $css_folder = WP_CONTENT_DIR . '/kkb-css/';
    $css_files = array_diff(scandir($css_folder), array('.', '..'));

    // Группируем файлы по полю 'group'
    $grouped_files = [];
    foreach ($css_files as $css_file) {
        $label = '';
        $group = 'Прочие'; // Группа по умолчанию

        foreach ($additional_files as $item) {
            if ($item['file'] === $css_file) {
                $label = $item['label'];
                if (!empty($item['group'])) {
                    $group = $item['group'];
                }
                break;
            }
        }

        if (empty($label)) {
            foreach ($checkbox_files as $item) {
                if ($item['file'] === $css_file) {
                    $label = $item['block'];
                    if (!empty($item['group'])) {
                        $group = $item['group'];
                    }
                    break;
                }
            }
        }

        // Если есть метка, добавляем в группу
        if (!empty($label)) {
            $grouped_files[$group][] = [
                'file' => $css_file,
                'label' => $label,
            ];
        }
    }

    ?>
    <div class="kkb-main-wrap kkb-wrap-files-delete-page">
		
		<!-- Меню -->
		
		<div class="kkb-menu-wrap">
			<div class="kkb-menu-logo">
				<h2>
					<span class="color-accent-2">Царский 2.0</span>
					<span class="logo-sup">Lite</span>
					<!--<span class="color-accent-1">набор рубрик</span>-->
					<!--<sup class="logo-sup">Lite</sup>-->
				</h2>
			</div>

			<div class="kkb-menu-links">
				<div class="kkb-menu-download-style-link-wrap">
					<a target="_blank" rel="noopener" href="https://memberlux.online/redirect-download-king-kit-blocks">Библиотека блоков</a>
				</div>

				<div class="kkb-menu-support-link-wrap">
					<a target="_blank" rel="noopener" href="https://memberlux.online/tg-super-style-mbl">Телеграм-чат</a>
				</div>

				<div class="kkb-menu-author-link-wrap">
					<a target="_blank" rel="noopener" href="https://memberlux.online/tg-igor-lokhman">Написать Игорю</a>
				</div>
				
				<div class="kkb-menu-lesson-link-wrap">
					<a class="kkb-lesson-button">Урок</a>
				</div>
				<!-- <div class="kkb-menu-admin-avatar-wrap"></div> -->
			</div>
		</div>
		
		
		<div class="kkb-wrap">
		
			<!-- СЕКЦИЯ - УДАЛЕНИЕ БЛОКОВ ПО ОДНОМУ -->
			
			<div class="kkb-section">
			
				<div class="kkb-delete-and-reset-single-css-wrap">
					<div class="kkb-list-exist-css-option-wrap">
						<h2>Удалить блоки по одному</h2>
						<p>Это безопасный вариант. Ваши настройки с дизайном при этом сохранятся.</p>
						<select id="kkb-list-exist-css-options" name="kkb-list-exist-css-options">
							<option value="">Выберите блок</option>
							<?php
							foreach ($grouped_files as $group => $files) {
								echo "<optgroup label='" . esc_html($group) . "'>";
								foreach ($files as $file_info) {
									$file = esc_attr($file_info['file']);
									$label = esc_html($file_info['label']);
									echo "<option value='$file'>$label</option>";
								}
								echo "</optgroup>";
							}
							?>
						</select>
					</div>

					<div class="kkb-delete-and-reset-single-css-buttons">
						<button class="kkb-delete-single-css-button kkb-medium-btn kkb-delete-btn kkb-btn" disabled>Удалить блок</button>
						<button class="kkb-reset-single-css-button kkb-medium-btn kkb-reset-btn kkb-btn" disabled>Сбросить</button>
					</div>
				</div>
			
			</div>
			
			<!-- СЕКЦИЯ - УДАЛЕНИЕ ВСЕХ БЛОКОВ -->
			
			<div class="kkb-section">
			
				 <div class="kkb-delete-and-reset-all-css-wrap">
					<h2>Удалить все блоки</h2>
					<p>Это вариант для смелых. Ваши настройки с дизайном при этом сохранятся.</p>
					<button class="kkb-delete-all-css-button kkb-medium-btn kkb-delete-btn kkb-btn">Удалить все блоки</button>
				</div>
			
			</div>
			
			<!-- Диалоговое окно alert - УДАЛИТЬ ОДИН ФАЙЛ? -->

			<div class="kkb-hidden-delete-single-css-alert-wrap" style="display: none;">
				<div class="kkb-hidden-delete-single-css-message">
					<div class="kkb-delete-alert-icon"></div>
					<div class="kkb-delete-alert-title">
						<h2>Точно уверены?</h2>
					</div>
					<div class="kkb-delete-alert-subtitle">
						<p>Если продолжите, то удалится один выбранный блок (css-файл), и он пропадёт из списка блоков в настройках рубрики. Убедитесь, что вы скачали резервную копию на свой компьютер в разделе «Экспорт». Уверены, что хотите удалить один выбранный блок?</p>
					</div>
					<div class="kkb-delete-alert-buttons-wrap">
						<button class="kkb-no-delete-single-css-button kkb-medium-btn kkb-reset-btn kkb-btn">Не удалять</button>
						<button class="kkb-yes-delete-single-css-button kkb-medium-btn kkb-delete-btn kkb-btn">Да, удалить этот блок</button>
					</div>
				</div>
			</div>
			
			<!-- Диалоговое окно alert - УДАЛИТЬ ВСЕ ФАЙЛЫ? -->

			<div class="kkb-hidden-delete-all-css-alert-wrap" style="display: none;">
				<div class="kkb-hidden-delete-all-css-message">
					<div class="kkb-delete-alert-icon"></div>
					<div class="kkb-delete-alert-title">
						<h2>Точно уверены?</h2>
					</div>
					<div class="kkb-delete-alert-subtitle">
						<p>Если продолжите, то удалятся абсолютно все блоки (css-файлы), и они пропадут из списка блоков в настройках рубрики. Убедитесь, что вы скачали резервную копию на свой компьютер в разделе «Экспорт». Уверены, что хотите удалить все блоки?</p>
					</div>
					<div class="kkb-delete-alert-buttons-wrap">
						<button class="kkb-no-delete-all-css-button kkb-medium-btn kkb-reset-btn kkb-btn">Не удалять</button>
						<button class="kkb-yes-delete-all-css-button kkb-medium-btn kkb-delete-btn kkb-btn">Да, удалить все блоки</button>
					</div>
				</div>
			</div>
			
			<!-- ПОП-АП С ВИДЕОУРОКОМ ПО ПРЕОБРАЖАТОРУ -->

			<div class="kkb-video-lesson-content-wrap" style="display: none;">
				<div class="kkb-video-lesson-content-window">
					<div class="kkb-video-player-wrap">
					<iframe src="https://player.vimeo.com/video/1102403720?badge=0&amp;autopause=0&amp;player_id=0&amp;app_id=58479" frameborder="0" allow="autoplay; fullscreen; picture-in-picture; clipboard-write; encrypted-media" style="position:absolute;top:0;left:0;width:100%;height:100%;" title="Царский набор рубрик 2.0 - большой обзор"></iframe>
					</div>
					<script src="https://player.vimeo.com/api/player.js"></script>
				</div>
			</div>
			
			<!-- ПРЕЛОАДЕР -->

			<div id="kkb-preloader" style="display: none;">
				<div id="kkb-preloader-content">
					<img src="<?php echo plugins_url('assets/icons/kkb-preloader.svg', dirname(__FILE__)); ?>" alt="Загрузка...">
				</div>
			</div>
			
		</div>
		
		<!--  ПОДВАЛ -->
		
		<div class="kkb-footer-wrap">
			<p class="kkb-plugin-title">Царский набор рубрик<span class="kkb-version"> (версия 2.0 LITE)</span></p>
			<p>© Игорь Лохман, 2025. Все права, надеюсь, защищены</p>
			<p class="kkb-footer-links"><a class="kkb-king-kit-link" target="_blank" rel="noopener" href="https://memberlux.online/redirect-king-kit">Презентация Царского набора</a>
			<a class="kkb-space-kit-link" target="_blank" rel="noopener" href="https://memberlux.online/redirect-space-kit">Космический набор материалов</a><a class="kkb-preobrazhator-link" target="_blank" rel="noopener" href="https://memberlux.online/redirect-land-preobrazhator">Преображатор Мемберлюкса</a></p>
		</div>

	</div>

    <?php
}

// AJAX для удаления одиночного файла
function kkb_delete_single_css_file() {
    $file = sanitize_text_field($_POST['file']);
    $css_folder = WP_CONTENT_DIR . '/kkb-css/' . $file;
    if (file_exists($css_folder)) {
        unlink($css_folder);
    }
    wp_send_json_success(); // Возвращаем пустой успешный ответ
}
add_action('wp_ajax_kkb_delete_single_css_file', 'kkb_delete_single_css_file');

// AJAX для удаления всех файлов
function kkb_delete_all_css_files() {
    global $additional_files, $checkbox_files;

    $css_folder = WP_CONTENT_DIR . '/kkb-css/';
    $files_to_delete = array_merge(
        array_column($additional_files, 'file'),
        array_column($checkbox_files, 'file')
    );

    foreach ($files_to_delete as $file) {
        $file_path = $css_folder . $file;
        if (file_exists($file_path)) {
            unlink($file_path);
        }
    }

    wp_send_json_success(); // Возвращаем пустой успешный ответ
}
add_action('wp_ajax_kkb_delete_all_css_files', 'kkb_delete_all_css_files');