<?php
/**
 * Plugin Name: ★ ЦАРСКИЙ НАБОР РУБРИК 2.0 LITE ДЛЯ МЕМБЕРЛЮКСА
 * Description: Превращает стандартные папки (рубрики) в современные классические карточки. Поддерживает 3, 4 и 5 карточек в ряду и настройки их дизайна прямо в админке.
 * Version: 2.0 LITE
 * Author: Игорь Лохман | <a href="https://memberlux.online/redirect-king-kit" target="_blank">Подробнее о Царском наборе</a> | <a href="https://memberlux.online/redirect-space-kit" target="_blank">Космический набор материалов</a>
 */

// Защита от прямого доступа
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

require_once plugin_dir_path(__FILE__) . 'includes/kkb-edit-cat-options.php';
require_once plugin_dir_path(__FILE__) . 'includes/kkb-edit-cat.php';
require_once plugin_dir_path(__FILE__) . 'includes/kkb-install.php';
require_once plugin_dir_path(__FILE__) . 'includes/kkb-design-settings.php';
require_once plugin_dir_path(__FILE__) . 'includes/kkb-files-export.php';
require_once plugin_dir_path(__FILE__) . 'includes/kkb-files-import.php';
require_once plugin_dir_path(__FILE__) . 'includes/kkb-files-delete.php';

require_once plugin_dir_path(__FILE__) . 'includes/kkb-upload-json.php';

// Подключаем основной css-файл kkb-main-css.css для всех админских страниц плагина
function kkb_enqueue_admin_main_css($hook_suffix) {
    wp_enqueue_style(
        'kkb-main-css-admin', 
        plugin_dir_url(__FILE__) . 'assets/css/kkb-main-css.css', 
        array(), 
        null
    );
	
	// Иконки UIcons - Flaticon
		
	wp_enqueue_style(
		'kkb-uicons-styles', 
		plugin_dir_url(__FILE__) . 'assets/icons/uicons-regular-rounded-2.6.0/css/uicons-regular-rounded.css'
	);
}
add_action('admin_enqueue_scripts', 'kkb_enqueue_admin_main_css');

// Подключаем стили для страницы настроек и скрипт с локализованными данными
function kkb_enqueue_admin_styles($hook_suffix) {
	
    if ($hook_suffix == 'toplevel_page_kkb-settings') {
        wp_enqueue_style('kkb-admin-style', plugin_dir_url(__FILE__) . 'assets/css/kkb-install.css');
        wp_enqueue_script('kkb-upload-js', plugin_dir_url(__FILE__) . 'assets/js/kkb-upload.js', array('jquery'), null, true);
        // wp_localize_script('kkb-upload-js', 'ajaxurl', admin_url('admin-ajax.php'));
		wp_localize_script('kkb-upload-js', 'kkbUploadData', [
		'ajaxurl' => admin_url('admin-ajax.php'),
		]);

        global $options_files, $additional_files;
        wp_localize_script('kkb-upload-js', 'kkbOptions', [
            'optionsFiles' => $options_files,
            'additionalFiles' => $additional_files,
        ]);

        wp_enqueue_script('kkb-checkbox-js', plugin_dir_url(__FILE__) . 'assets/js/kkb-checkbox.js', array('jquery'), null, true);
        global $checkbox_files;
        wp_localize_script('kkb-checkbox-js', 'kkbCheckboxOptions', [
            'checkboxFiles' => $checkbox_files,
        ]);
		
		// Подключаем наш новый скрипт для переключателей
        wp_enqueue_script('kkb-radio-button-js', plugin_dir_url(__FILE__) . 'assets/js/kkb-radio-button.js', array('jquery'), null, true);
        // wp_localize_script('kkb-radio-button-js', 'ajaxurl', admin_url('admin-ajax.php'));
		wp_localize_script('kkb-radio-button-js', 'kkbRadioData', [
		'ajaxurl' => admin_url('admin-ajax.php'),
		]);
		
		// Подключение нового скрипта для обработки завершения сохранения
        wp_enqueue_script('kkb-save-all-options-js', plugin_dir_url(__FILE__) . 'assets/js/kkb-save-all-options.js', array('jquery'), null, true);
		
		// Подключаем kkb-upload-json.js на странице настроек
		wp_enqueue_script(
            'kkb-upload-json-js', 
            plugin_dir_url(__FILE__) . 'assets/js/kkb-upload-json.js', 
            ['jquery'], 
            null, 
            true
        );
        // wp_localize_script('kkb-upload-json-js', 'ajaxurl', admin_url('admin-ajax.php'));
		wp_localize_script('kkb-upload-json-js', 'kkbJsonData', [
		'ajaxurl' => admin_url('admin-ajax.php'),
		]);
    }
	
	// Если это не наша страница — сразу выход
    if ( ! isset($_GET['page']) || $_GET['page'] !== 'kkb-design-settings' ) {
        return;
    }
	
	// Здесь мы точно находимся внутри admin.php?page=kkb-design-settings
    wp_enqueue_style('kkb-design-settings-style', plugin_dir_url(__FILE__) . 'assets/css/kkb-design-settings.css');
    wp_enqueue_script('kkb-design-settings', plugin_dir_url(__FILE__) . 'assets/js/kkb-design-settings.js', ['jquery'], '1.0.0', true);
    wp_localize_script('kkb-design-settings', 'kkbData', [
        'ajaxUrl'        => admin_url('admin-ajax.php'),
        'jsonUrl'        => WP_CONTENT_URL . '/kkb-css/',
        // 'jsonUrl'        => content_url('kkb-css/'),
        'defaultJsonUrl' => plugin_dir_url(__FILE__) . 'start-json-vars/'
    ]);
}
add_action('admin_enqueue_scripts', 'kkb_enqueue_admin_styles');

// Функция для видео-урока - определяем нужные страницы плагина

function kkb_enqueue_video_lesson_script() {
    // Проверяем, что в URL есть параметр page и он начинается с "kkb-"
    if (
        isset($_GET['page'])
        && strncmp($_GET['page'], 'kkb-', 4) === 0 // проверяем первые 4 символа строки (kkb-)
    ) {
        wp_enqueue_script(
            'kkb-video-lesson-popup',
            plugin_dir_url(__FILE__) . 'assets/js/kkb-video-lesson-popup.js',
            array('jquery'),
            '1.0.0',
            true
        );
    }
}
add_action('admin_enqueue_scripts', 'kkb_enqueue_video_lesson_script');

// Функция для добавления страницы в меню
function kkb_add_admin_menu() {
    // Главный пункт меню
    add_menu_page(
        'Царский набор блоков',      // Заголовок страницы
        'Царский набор',             // Название в меню
        'manage_options',            // Права доступа
        'kkb-settings',              // Слаг страницы
        'kkb_plugin_settings_page',  // Функция отображения
		plugin_dir_url(__FILE__) . 'assets/icons/kkb-menu-icon.png', // Путь к иконке
        4                            // Позиция в меню
    );

    // Подпункт "Установить блоки"
    add_submenu_page(
        'kkb-settings',              // Родительская страница
        'Установить блоки',           // Заголовок страницы
        '1. Установить блоки',           // Название меню
        'manage_options',            // Права доступа
        'kkb-settings',              // Слаг страницы (совпадает с главным пунктом меню)
        'kkb_plugin_settings_page'   // Функция отображения (совпадает с главным пунктом меню)
    );

    // Подпункт "Настроить дизайн"
    add_submenu_page(
        'kkb-settings',              // Родительская страница
        'Настроить дизайн',          // Заголовок страницы
        '2. Настроить дизайн',          // Название меню
        'manage_options',            // Права доступа
        'kkb-design-settings',       // Слаг страницы
        'kkb_design_settings_page'   // Функция отображения
    );
	
	// Подпункт "Экспорт"
    add_submenu_page(
        'kkb-settings',              // Родительская страница
        'Экспорт блоков и их настроек', // Заголовок страницы
        'Экспорт',		             // Название меню
        'manage_options',            // Права доступа
        'kkb-files-export',          // Слаг страницы
        'kkb_files_export_page'      // Функция отображения
    );
	
	// Подпункт "Импорт"
    add_submenu_page(
        'kkb-settings',              // Родительская страница
        'Импорт блоков и их настроек',  // Заголовок страницы
        'Импорт',		             // Название меню
        'manage_options',            // Права доступа
        'kkb-files-import',          // Слаг страницы
        'kkb_files_import_page'      // Функция отображения
    );
	
	// Подпункт "Очистка"
    add_submenu_page(
        'kkb-settings',              // Родительская страница
        'Удаление блоков', // Заголовок страницы
        'Очистка',		             // Название меню
        'manage_options',            // Права доступа
        'kkb-files-delete',          // Слаг страницы
        'kkb_files_delete_page'      // Функция отображения
    );
}
add_action('admin_menu', 'kkb_add_admin_menu');

function kkb_create_css_folder() {
    $css_folder_path = WP_CONTENT_DIR . '/kkb-css';
    $json_file_path = $css_folder_path . '/kkb-active-css.json';
    $main_css_json_file_path = $css_folder_path . '/kkb-active-main-css.json';

    if ( ! file_exists( $css_folder_path ) ) {
        wp_mkdir_p( $css_folder_path );
    }

    if ( ! file_exists( $json_file_path ) ) {
        $default_active = array(
            'off-card',
            'move-to-right-card',
        );
        file_put_contents( $json_file_path, json_encode( $default_active ) );
    }

    /* if ( ! file_exists( $json_file_path ) ) {
        file_put_contents( $json_file_path, json_encode([]));
    } */

    if ( ! file_exists( $main_css_json_file_path ) ) {
        file_put_contents($main_css_json_file_path, json_encode(['activeFile' => 'folder-to-card-3']));
    }

    $source_folder = plugin_dir_path(__FILE__) . 'icons-example';
    $destination_folder = $css_folder_path . '/icons-example';

    if (file_exists($source_folder)) {
        kkb_copy_folder($source_folder, $destination_folder);
    }
}

// Вспомогательная функция для копирования папок рекурсивно
function kkb_copy_folder($src, $dst) {
    // Создаем целевую папку, если её нет
    if (!file_exists($dst)) {
        mkdir($dst, 0755, true);
    }

    // Открываем папку-источник
    $dir = opendir($src);

    while (false !== ($file = readdir($dir))) {
        if ($file != '.' && $file != '..') {
            if (is_dir($src . '/' . $file)) {
                kkb_copy_folder($src . '/' . $file, $dst . '/' . $file);
            } else {
                copy($src . '/' . $file, $dst . '/' . $file);
            }
        }
    }
    closedir($dir);
}

register_activation_hook( __FILE__, 'kkb_create_css_folder' );
register_activation_hook( __FILE__, 'kkb_copy_json_files_on_activation' ); // Вызов функции копирования JSON-файлов при активации

// Обработчик AJAX для загрузки файлов
function kkb_upload_css_files() {
    if (!current_user_can('manage_options')) {
        wp_send_json_error(['message' => 'Недостаточно прав.']);
        return;
    }

    $upload_dir = WP_CONTENT_DIR . '/kkb-css/';

    if (!file_exists($upload_dir)) {
        wp_mkdir_p($upload_dir);
    }

    $uploaded_files = [];
    foreach ($_FILES as $file) {
        $file_name = basename($file['name']);

        $target_file = $upload_dir . $file_name;

        if (move_uploaded_file($file['tmp_name'], $target_file)) {
            $uploaded_files[] = $file_name;
        }
    }

    // Проверяем, удалось ли загрузить хотя бы один файл
    if (empty($uploaded_files)) {
        wp_send_json_error(['message' => 'Не удалось загрузить файлы.']);
    } else {
        wp_send_json_success(['uploaded' => $uploaded_files]);
    }
}
add_action('wp_ajax_kkb_upload_css_files', 'kkb_upload_css_files');

// Обработчик AJAX для проверки наличия файлов
function kkb_check_files_exist() {
    // Проверяем права доступа
    if (!current_user_can('manage_options')) {
        wp_send_json_error(['message' => 'Недостаточно прав.']);
        return;
    }

    $upload_dir = WP_CONTENT_DIR . '/kkb-css/';
    $requested_files = json_decode(file_get_contents('php://input'), true)['files'] ?? [];
    $existing_files = [];

    foreach ($requested_files as $file_name) {
        if (file_exists($upload_dir . $file_name)) {
            $existing_files[] = $file_name;
        }
    }

    wp_send_json(['exists' => $existing_files]);
}
add_action('wp_ajax_kkb_check_files_exist', 'kkb_check_files_exist');

function kkb_check_checkbox_files_exist() {
    if (!current_user_can('manage_options')) {
        wp_send_json_error(['message' => 'Недостаточно прав.']);
        return;
    }

    $upload_dir = WP_CONTENT_DIR . '/kkb-css/';
    $requested_files = isset($_POST['files']) ? $_POST['files'] : [];
    $existing_files = [];

    foreach ($requested_files as $file_name) {
        if (file_exists($upload_dir . $file_name)) {
            $existing_files[] = $file_name;
        }
    }

    wp_send_json_success(['exists' => $existing_files]);
}
add_action('wp_ajax_kkb_check_checkbox_files_exist', 'kkb_check_checkbox_files_exist');

function kkb_load_active_css() {
    if (!current_user_can('manage_options')) {
        wp_send_json_error(['message' => 'Недостаточно прав.']);
        return;
    }

    $json_file_path = WP_CONTENT_DIR . '/kkb-css/kkb-active-css.json';
    $active_files = file_exists($json_file_path) ? json_decode(file_get_contents($json_file_path), true) : [];

    wp_send_json_success(['activeFiles' => $active_files]);
}
add_action('wp_ajax_kkb_load_active_css', 'kkb_load_active_css');

function kkb_save_active_css() {
    if (!current_user_can('manage_options')) {
        wp_send_json_error(['message' => 'Недостаточно прав.']);
        return;
    }

    $active_files = isset($_POST['activeFiles']) ? array_map('sanitize_text_field', $_POST['activeFiles']) : [];
    $json_file_path = WP_CONTENT_DIR . '/kkb-css/kkb-active-css.json';

    if (file_put_contents($json_file_path, json_encode($active_files))) {
        wp_send_json_success(['message' => 'Файлы сохранены.']);
    } else {
        wp_send_json_error(['message' => 'Ошибка при сохранении.']);
    }
}
add_action('wp_ajax_kkb_save_active_css', 'kkb_save_active_css');

// С буферизацией

global $kkb_css_files, $kkb_css_vars;
$kkb_css_files = [];
$kkb_css_vars = '';

add_action('wp', function() {
    global $kkb_css_files, $kkb_css_vars;

    ob_start(function($buffer) {
        $json_file_path = WP_CONTENT_DIR . '/kkb-css/kkb-active-css.json';
        $css_folder_url = content_url('/kkb-css/');
        
        if (file_exists($json_file_path)) {
            $active_files = json_decode(file_get_contents($json_file_path), true);
            $styles = '';
            $css_vars = ':root {' . PHP_EOL;

            foreach ($active_files as $file_id) {
                $css_file_path = WP_CONTENT_DIR . '/kkb-css/' . $file_id . '.css';
                if (file_exists($css_file_path)) {
                    $file_url = $css_folder_url . $file_id . '.css';
                    $kkb_css_files[] = $file_id; // Сохраняем подключенные файлы

                    // Формируем стили
                    $styles .= sprintf(
                        '<link rel="stylesheet" id="kkb-css-%s-css" href="%s" media="all" />' . "\n",
                        esc_attr($file_id),
                        esc_url($file_url)
                    );

                    // Собираем переменные
                    $json_file_path = WP_CONTENT_DIR . '/kkb-css/' . $file_id . '-vars.json';
                    if (file_exists($json_file_path)) {
                        $json_data = json_decode(file_get_contents($json_file_path), true);
                        if ($json_data && is_array($json_data)) {
                            foreach ($json_data as $var_name => $attributes) {
                                $value = isset($attributes['value']) ? $attributes['value'] : '';
                                $unit = isset($attributes['unit']) ? $attributes['unit'] : '';
                                // $css_vars .= "--$var_name: $value$unit;" . PHP_EOL;
								
								// Формируем переменную в зависимости от типа
								switch ($attributes['type']) {
									case 'text':
										// Заменяем двойной слеш на одинарный, чтобы сохранить исходный формат
										$value = str_replace('\\\\', '\\', $value);
										$css_vars .= "--$var_name: '$value';" . PHP_EOL;
										break;
									case 'url':
										$css_vars .= "--$var_name: url(\"$value\");" . PHP_EOL;
										break;
									default:
										$css_vars .= "--$var_name: $value$unit;" . PHP_EOL;
								}
                            }
                        }
                    }
                }
            }

            $css_vars .= '}' . PHP_EOL;

            // Формируем вставку переменных
            if (!empty($css_vars)) {
                $kkb_css_vars = "<style id='kkb-block-design-css'>$css_vars</style>\n";
            }

            // Вставляем стили и переменные
            $insert_content = $kkb_css_vars . "<!-- -->\n" 
                            . $styles 
                            . "<!-- -->\n";

            $buffer = str_replace('</head>', $insert_content . '</head>', $buffer);
        }

        return $buffer;
    });
});

// Безопасно завершаем буферизацию, если она всё ещё активна
add_action('shutdown', function() {
    if (ob_get_length()) {
        ob_end_flush();
    }
});

function kkb_save_active_main_css() {
    if (!current_user_can('manage_options')) {
        wp_send_json_error(['message' => 'Недостаточно прав.']);
        return;
    }

    $active_file = sanitize_text_field($_POST['activeFile'] ?? '');
    $json_file_path = WP_CONTENT_DIR . '/kkb-css/kkb-active-main-css.json';

    if (file_put_contents($json_file_path, json_encode(['activeFile' => $active_file]))) {
        wp_send_json_success(['message' => 'Файл сохранен.']);
    } else {
        wp_send_json_error(['message' => 'Ошибка при сохранении.']);
    }
}
add_action('wp_ajax_kkb_save_active_main_css', 'kkb_save_active_main_css');

function kkb_load_active_main_css() {
    if (!current_user_can('manage_options')) {
        wp_send_json_error(['message' => 'Недостаточно прав.']);
        return;
    }

    $json_file_path = WP_CONTENT_DIR . '/kkb-css/kkb-active-main-css.json';
    $active_file = file_exists($json_file_path) ? json_decode(file_get_contents($json_file_path), true)['activeFile'] : 'folder-to-card-3';

    wp_send_json_success(['activeFile' => $active_file]);
}
add_action('wp_ajax_kkb_load_active_main_css', 'kkb_load_active_main_css');

// С буферизацией

add_action('wp', function() {
    ob_start(function($buffer) {
        $json_file_path = WP_CONTENT_DIR . '/kkb-css/kkb-active-main-css.json';
        $css_folder_url = content_url('/kkb-css/');
        
        if (file_exists($json_file_path)) {
            $data = json_decode(file_get_contents($json_file_path), true);
            $active_file = isset($data['activeFile']) ? $data['activeFile'] : null;
            $main_css_vars = '';

            if ($active_file) {
                $css_file_path = WP_CONTENT_DIR . '/kkb-css/' . $active_file . '.css';
                if (file_exists($css_file_path)) {
                    $file_url = $css_folder_url . $active_file . '.css';

                    // Формируем переменные
                    $json_vars_path = WP_CONTENT_DIR . '/kkb-css/' . $active_file . '-vars.json';
                    if (file_exists($json_vars_path)) {
                        $json_data = json_decode(file_get_contents($json_vars_path), true);
                        $css_vars = ':root {' . PHP_EOL;

                        if ($json_data && is_array($json_data)) {
                            foreach ($json_data as $var_name => $attributes) {
                                $value = isset($attributes['value']) ? $attributes['value'] : '';
                                $unit = isset($attributes['unit']) ? $attributes['unit'] : '';

                                // Формируем переменную в зависимости от типа
                                switch ($attributes['type']) {
                                    case 'text':
                                        $value = str_replace('\\\\', '\\', $value);
                                        $css_vars .= "--$var_name: '$value';" . PHP_EOL;
                                        break;
                                    case 'url':
                                        $css_vars .= "--$var_name: url(\"$value\");" . PHP_EOL;
                                        break;
                                    default:
                                        $css_vars .= "--$var_name: $value$unit;" . PHP_EOL;
                                }
                            }
                        }

                        $css_vars .= '}' . PHP_EOL;
                        $main_css_vars = "<style id='kkb-main-design-css'>$css_vars</style>\n";
                    }

                    // Формируем тег
                    $styles = sprintf(
                        "\n<!-- -->\n" .
                        '<link rel="stylesheet" id="kkb-main-css-css" href="%s" media="all" />' . "\n" .
                        "<!-- -->\n",
                        esc_url($file_url)
                    );

                    // Вставляем переменные и стиль
                    $buffer = str_replace('</head>', $main_css_vars . $styles . '</head>', $buffer);
                }
            }
        }

        return $buffer;
    });
});

// Безопасно завершаем буферизацию, если она всё ещё активна
add_action('shutdown', function() {
    if (ob_get_length()) {
        ob_end_flush();
    }
});

// Подключение функции для отображения HTML опций
// add_action( 'admin_footer', 'wpm_add_slug_options' );

function wpm_enqueue_secret_phrases_script($hook_suffix) {
    // if ( isset($_GET['taxonomy']) && $_GET['taxonomy'] === 'wpm-category' ) {      
	// Глобальная переменная, чтобы знать, какая именно это админ-страница (term.php, edit-tags.php)
    global $pagenow;

    // Проверяем, что мы именно в term.php
    // и что в URL присутствуют taxonomy=wpm-category и tag_ID=<число>
    if (
        $pagenow === 'term.php'
        && isset($_GET['taxonomy']) && $_GET['taxonomy'] === 'wpm-category'
        && isset($_GET['tag_ID']) && is_numeric($_GET['tag_ID'])
    ) {	

		// Подключаем стили
		wp_enqueue_style('kkb-edit-cat-style', plugin_dir_url(__FILE__) . 'assets/css/kkb-edit-cat.css');

		wp_enqueue_script(
            'secret-phrases-plugin', 
            plugin_dir_url(__FILE__) . 'assets/js/kkb-edit-cat.js', 
            array(), 
            null, 
            true  
        );

        wp_localize_script('secret-phrases-plugin', 'kkbActiveCssData', [
            'jsonUrl' => content_url('kkb-css/kkb-active-css.json')
        ]);
        
        echo '<script>
            window.pluginsUrl = "' . plugin_dir_url(__FILE__) . '";
        </script>';
    }
}
add_action('admin_enqueue_scripts', 'wpm_enqueue_secret_phrases_script');

// Добавляем favicon только на тех админ-страницах, где ?page=kkb-

function kkb_add_favicon_to_plugin_pages() {
	// Проверяем, что в URL есть параметр page и он начинается с "kkb-"
    if (
        isset($_GET['page']) &&
        strncmp($_GET['page'], 'kkb-', 4) === 0
    ) {
        // Генерируем правильный URL до favicon.svg внутри плагина
        $favicon_url = plugins_url( 'assets/icons/favicon.svg', __FILE__ );
        echo '<link rel="icon" href="' . esc_url( $favicon_url ) . '" type="image/svg+xml" />';
    }
}
add_action( 'admin_head', 'kkb_add_favicon_to_plugin_pages' );

// Функция для добавления стилей иконки меню

function kkb_custom_menu_icon_style() {
    ?>
    <style>
	
		/* нижний отступ пункта меню */
		
		#adminmenu li.toplevel_page_kkb-settings {
			margin-bottom: 10px;
		}
	
		/* Стили для иконки главного пункта меню */
		
        #toplevel_page_kkb-settings .wp-menu-image img,
		.toplevel_page_kkb-settings .wp-menu-image img {
            width: 20px;
			height: 25px;
			margin-top: -5px;
			margin-left: 0px;
			opacity: 1;
			padding: 9px 0 0 !important;
			max-width: none;
			max-height: none;
        }
		
		#adminmenu li.current a.toplevel_page_kkb-settings .wp-menu-image img,
		#toplevel_page_kkb-settings a.toplevel_page_kkb-settings:focus .wp-menu-image img {
			opacity: 1;
		}
		
		/* Пункт меню "Царский набор" в фокусе - в раскрытом подменю - при свёрнутой боковой панели */
		/* Чтобы этот пункт был по высоте как пункт с иконкой слева */
		
		.folded #adminmenu li.toplevel_page_kkb-settings a.toplevel_page_kkb-settings:focus + .wp-submenu .wp-submenu-head,
		.folded #adminmenu li.toplevel_page_kkb-settings a.toplevel_page_kkb-settings:hover + .wp-submenu .wp-submenu-head,
		.folded #adminmenu li.toplevel_page_kkb-settings.opensub a.toplevel_page_kkb-settings + .wp-submenu .wp-submenu-head {
			font-size: 15px;
			color: #ffffff;
			background: #04a777;
		}
		
		/* Убираем рамку слева при наведении на главный пункт меню - при свёрнутой боковой панели */
		
		.folded #adminmenu li.toplevel_page_kkb-settings a.toplevel_page_kkb-settings:focus + .wp-submenu .wp-submenu-head:hover,
		.folded #adminmenu li.toplevel_page_kkb-settings.opensub a.toplevel_page_kkb-settings + .wp-submenu .wp-submenu-head:hover {
			box-shadow: none;
		}

		/* Цвет стрелки при наведении на главный пункт меню - при свёрнутой боковой панели */
		
		.folded #adminmenu li.toplevel_page_kkb-settings.opensub.wp-has-submenu:hover:after,
		.folded #adminmenu li.toplevel_page_kkb-settings.opensub.wp-has-submenu:focus-within:after,
		.folded #adminmenu li.toplevel_page_kkb-settings.wp-menu-open.wp-has-submenu:hover:after {
			border-right-color: #ffffff!important;
		}
		
		/* Цвет стрелки - при активной главной странице плагина */
		/* Делаем её цветом фона страниц плагина */
		
		#adminmenu li.toplevel_page_kkb-settings.wp-has-current-submenu a.toplevel_page_kkb-settings.wp-has-current-submenu:after {
			border-right-color: #F6F8FA!important;
		}

		/* Пункт меню НЕ раскрытый */
		
		#adminmenu li.toplevel_page_kkb-settings a.toplevel_page_kkb-settings {
			background: #04a777;
		}
		
		/* Пункт меню НЕ раскрытый - при наведении */
		
		#adminmenu li.toplevel_page_kkb-settings a.toplevel_page_kkb-settings:hover {
			background: #04B681;
		}
		
		/* Текст меню НЕ раскрытый - при наведении */
		
		#adminmenu li.toplevel_page_kkb-settings a.toplevel_page_kkb-settings div.wp-menu-name:hover {
			color: #ffffff;
		}
		
		/* Текст меню НЕ раскрытый - при клике колёсиком мыши */
		
		#adminmenu li.toplevel_page_kkb-settings>a.toplevel_page_kkb-settings:focus {
			color: #ffffff;
		}
		
		/* Текст меню НЕ раскрытый - при потере наведения */
		
		#toplevel_page_kkb-settings a {
			color: #ffffff;
        }
		
		/* Текст меню - при раскрытом подменю - при потере наведения */
		
		#adminmenu li.toplevel_page_kkb-settings.opensub a.toplevel_page_kkb-settings div.wp-menu-name {
			color: #ffffff;
		}
		
		/* Пункты выпадающего подменю - при наведении */
		
		#adminmenu li.toplevel_page_kkb-settings.opensub .wp-submenu li a:hover,
		#adminmenu li.toplevel_page_kkb-settings.opensub .wp-submenu li a:focus {
			color: #ffffff;
			box-shadow: inset 4px 0 0 0 #04a777;
		}
		
		/* Пункты открытого меню - при наведении */
		
		#adminmenu li.toplevel_page_kkb-settings.wp-menu-open .wp-submenu li a:hover,
		#adminmenu li.toplevel_page_kkb-settings.wp-menu-open .wp-submenu li a:focus {
			color: #ffffff;
			box-shadow: inset 4px 0 0 0 #04a777;
		}
		
		/* Анимация пункта меню */
		
		#adminmenu li.toplevel_page_kkb-settings a,
		#adminmenu li.toplevel_page_kkb-settings a:hover,
		#adminmenu li.toplevel_page_kkb-settings a:focus {
			transition: background .1s linear;
		}
		
		/* Убираем рамку слева при наведении на главный пункт меню */
		
		#adminmenu a.toplevel_page_kkb-settings:hover,
		#adminmenu li.toplevel_page_kkb-settings>a.menu-top:focus {
			box-shadow: none;
		}
    </style>
    <?php
}
add_action('admin_head', 'kkb_custom_menu_icon_style');