<?php

if (!defined('ABSPATH')) {
    exit;
}

add_action('wp_ajax_ss_get_css_file_content', 'ss_get_css_file_content');
function ss_get_css_file_content()
{
    check_ajax_referer('ss-edit-single-css-file', 'nonce');

    $file_name = sanitize_text_field($_POST['fileName']);
    $file_path = WP_CONTENT_DIR . '/ss-css/' . $file_name;

    if (!file_exists($file_path)) {
        wp_send_json_error(['message' => 'Файл не найден.']);
    }

    $content = file_get_contents($file_path);
    wp_send_json_success(['content' => $content]);
}

add_action('wp_ajax_ss_save_css_file_content', 'ss_save_css_file_content');
function ss_save_css_file_content()
{
    check_ajax_referer('ss-edit-single-css-file', 'nonce');

    $file_name = sanitize_text_field($_POST['fileName']);
    $file_content = stripslashes($_POST['content']);
    $file_path = WP_CONTENT_DIR . '/ss-css/' . $file_name;

    if (!file_exists($file_path)) {
        wp_send_json_error(['message' => 'Файл не найден.']);
    }

    $result = file_put_contents($file_path, $file_content);
    if ($result === false) {
        wp_send_json_error(['message' => 'Не удалось сохранить файл.']);
    }

    wp_send_json_success(['message' => 'Изменения успешно сохранены.']);
}