jQuery(document).ready(function ($) {
    const lessonWrap = $('.ss-video-lesson-content-wrap');
    const lessonButton = $('.ss-lesson-button');
    const iframe = document.querySelector('.ss-video-player-wrap iframe');
    const player = new Vimeo.Player(iframe);

    const fadeIn = (element, duration = 300) => {
        $(element).css("opacity", 0).css("display", "flex").animate({ opacity: 1 }, duration);
    };

    const fadeOut = (element, duration = 300) => {
        $(element).animate({ opacity: 0 }, duration, function () {
            $(this).css("display", "none");
        });
    };

    lessonButton.on('click', function () {
        fadeIn(lessonWrap);
    });

	$(document).on("click", ".ss-video-lesson-content-wrap", function (e) {
		if (!$(e.target).closest(".ss-video-lesson-content-window").length) {
			fadeOut($(this));
			player.pause();
		}
	});

    $(document).on('keydown', function (e) {
        if (e.key === 'Escape' || e.keyCode === 27) {
			e.preventDefault();
            e.stopPropagation();
			
            if (lessonWrap.is(':visible')) {
                fadeOut(lessonWrap);
				player.pause();
            }
        }
    });
});