<?php
if (!defined('ABSPATH')) {
    exit;
}

add_action('wp_ajax_ss_delete_all_css_files', 'ss_delete_all_css_files_handler');

function ss_delete_all_css_files_handler()
{
    check_ajax_referer('ss-delete-css-files', 'nonce');

    $css_dir = WP_CONTENT_DIR . '/ss-css';

    if (!file_exists($css_dir) || !is_dir($css_dir)) {
        wp_send_json_error(['message' => 'CSS directory not found.']);
        return;
    }

    $files = array_merge(
        glob("{$css_dir}/*.css"),
        glob("{$css_dir}/*.js")
    );

    if (empty($files)) {
        wp_send_json_error(['message' => 'No CSS or JS files to delete.']);
        return;
    }

    foreach ($files as $file) {
        if (is_file($file)) {
            unlink($file);
        }
    }

    wp_send_json_success(['message' => 'All CSS and JS files have been deleted.']);
}