<?php

if (!defined('ABSPATH')) {
    exit;
}

add_action('wp_ajax_ss_delete_single_css_file', 'ss_delete_single_css_file');
add_action('wp_ajax_nopriv_ss_delete_single_css_file', 'ss_delete_single_css_file');

function ss_delete_single_css_file()
{

    error_log('Имя файла из запроса: ' . ($_POST['fileName'] ?? 'Нет имени файла'));

    if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'ss-delete-single-css-file')) {
        error_log('Ошибка nonce');
		wp_send_json_error(['message' => 'Неверный nonce.']);
    }

    $fileName = sanitize_file_name($_POST['fileName']);
    if (empty($fileName)) {
        error_log('Имя файла отсутствует.');
        wp_send_json_error(['message' => 'Имя файла отсутствует.']);
    }

    $filePath = ABSPATH . 'wp-content/ss-css/' . $fileName;
	
	error_log('Путь к файлу: ' . $filePath);

    if (!file_exists($filePath)) {
        error_log('Файл не существует: ' . $filePath);
        wp_send_json_error(['message' => 'Файл не найден.']);
    }

    if (!is_writable($filePath)) {
        error_log('Недостаточно прав для удаления файла: ' . $filePath);
        wp_send_json_error(['message' => 'Недостаточно прав для удаления файла.']);
    }

    if (unlink($filePath)) {
        error_log('Файл успешно удалён: ' . $filePath);
        wp_send_json_success(['message' => 'Файл успешно удалён.']);
    } else {
        error_log('Не удалось удалить файл: ' . $filePath);
        wp_send_json_error(['message' => 'Не удалось удалить файл.']);
    }
}