<?php
/**
 * Plugin Name: ★ ПРЕОБРАЖАТОР МЕМБЕРЛЮКСА
 * Description: Ваш собственный центр установки и управления стилями и скриптами.
 * Version: 1.0
 * Author: Игорь Лохман | <a href="https://memberlux.online/redirect-king-kit" target="_blank">Царский набор рубрик</a> | <a href="https://memberlux.online/redirect-space-kit" target="_blank">Космический набор материалов</a>
 */

if (!defined('ABSPATH')) {
    exit;
}

require_once plugin_dir_path(__FILE__) . 'includes/ss-all-css-files-export.php';
require_once plugin_dir_path(__FILE__) . 'includes/ss-all-css-files-delete.php';
require_once plugin_dir_path(__FILE__) . 'includes/ss-single-css-file-export.php';
require_once plugin_dir_path(__FILE__) . 'includes/ss-single-css-file-delete.php';
require_once plugin_dir_path(__FILE__) . 'includes/ss-single-css-file-edit.php';
require_once plugin_dir_path(__FILE__) . 'includes/ss-manually-css-upload.php';

function ss_deactivate_plugin() {
    wp_clear_scheduled_hook('ss_cleanup_old_exports');
}

// register_activation_hook(__FILE__, 'ss_activate_plugin');
register_deactivation_hook(__FILE__, 'ss_deactivate_plugin');

function ss_add_admin_menu() {
    add_menu_page(
        'Преображатор Мемберлюкса',
        'Преображатор',
        'manage_options',
        'super-style',
        'ss_files_upload_page',
        plugin_dir_url(__FILE__) . 'assets/icons/ss-menu-icon-white.png',
        4
    );
}
add_action('admin_menu', 'ss_add_admin_menu');

function ss_enqueue_admin_styles($hook_suffix) {
    if ($hook_suffix === 'toplevel_page_super-style') {
		
		wp_enqueue_style(
            'ss-main-styles', 
            plugin_dir_url(__FILE__) . 'assets/css/ss-main.css'
        );
		
		wp_enqueue_style(
            'ss-light-theme', 
            plugin_dir_url(__FILE__) . 'assets/css/ss-light-theme.css'
        );
		
		wp_enqueue_style(
            'ss-dark-theme', 
            plugin_dir_url(__FILE__) . 'assets/css/ss-dark-theme.css'
        );

        add_action('admin_head', function() {
            ?>
            <style>
                link[rel="stylesheet"][href*="ss-light-theme.css"],
                link[rel="stylesheet"][href*="ss-dark-theme.css"] {
                    display: none;
                }
            </style>
            <script>
                (function() {
                    let theme = localStorage.getItem('ss_theme') || 'light';
                    let lightTheme = document.querySelector('link[href*="ss-light-theme.css"]');
                    let darkTheme = document.querySelector('link[href*="ss-dark-theme.css"]');

                    if (theme === 'dark') {
                        if (lightTheme) lightTheme.disabled = true;
                        if (darkTheme) darkTheme.disabled = false;
                    } else {
                        if (lightTheme) lightTheme.disabled = false;
                        if (darkTheme) darkTheme.disabled = true;
                    }

                    if (lightTheme) lightTheme.removeAttribute('style');
                    if (darkTheme) darkTheme.removeAttribute('style');
                })();
            </script>
            <?php
        }, 1);
		
		wp_enqueue_style(
            'ss-uicons-styles', 
            plugin_dir_url(__FILE__) . 'assets/icons/uicons-regular-rounded-2.6.0/css/uicons-regular-rounded.css'
        );

		wp_enqueue_script(
			'ss-all-css-files-export',
			plugins_url('assets/js/ss-all-css-files-export.js', __FILE__),
			['jquery'],
			'1.0.0',
			true
		);

		wp_localize_script('ss-all-css-files-export', 'ssExportPluginData', [
			'ajaxUrl' => admin_url('admin-ajax.php'),
			'nonce' => wp_create_nonce('ss-export-css-files')
		]);

		wp_enqueue_script(
			'ss-all-css-files-delete',
			plugins_url('assets/js/ss-all-css-files-delete.js', __FILE__),
			['jquery'],
			'1.0.0',
			true
		);
		
		wp_localize_script('ss-all-css-files-delete', 'ssDeletePluginData', [
        'ajaxUrl' => admin_url('admin-ajax.php'),
        'nonce' => wp_create_nonce('ss-delete-css-files'),
		]);
	
		wp_enqueue_script(
			'ss-single-css-file-export',
			plugin_dir_url(__FILE__) . 'assets/js/ss-single-css-file-export.js',
			['jquery'],
			'1.0.0',
			true
		);
		
		wp_localize_script('ss-single-css-file-export', 'ssExportSinglePluginData', [
			'ajaxUrl' => admin_url('admin-ajax.php'),
			'nonce' => wp_create_nonce('ss-export-single-css-file'),
		]);
		
		wp_enqueue_script(
			'ss-single-css-file-delete',
			plugin_dir_url(__FILE__) . 'assets/js/ss-single-css-file-delete.js',
			['jquery'],
			'1.0.0',
			true
		);
		
		wp_localize_script('ss-single-css-file-delete', 'ssDeleteSinglePluginData', [
			'ajaxUrl' => admin_url('admin-ajax.php'),
			'nonce' => wp_create_nonce('ss-delete-single-css-file'),
		]);
		
		wp_enqueue_script(
			'ss-single-css-file-edit',
			plugin_dir_url(__FILE__) . 'assets/js/ss-single-css-file-edit.js',
			['jquery'],
			'1.0.0',
			true
		);

		wp_localize_script('ss-single-css-file-edit', 'ssEditSinglePluginData', [
			'ajaxUrl' => admin_url('admin-ajax.php'),
			'nonce' => wp_create_nonce('ss-edit-single-css-file'),
		]);
		
        wp_enqueue_style(
            'codemirror-css',
            plugins_url('assets/codemirror-5.65.18/lib/codemirror.css', __FILE__)
        );
        wp_enqueue_script(
            'codemirror-js',
            plugins_url('assets/codemirror-5.65.18/lib/codemirror.js', __FILE__),
            [],
            null,
            true
        );
        wp_enqueue_script(
            'codemirror-mode-css',
            plugins_url('assets/codemirror-5.65.18/mode/css/css.js', __FILE__),
            ['codemirror-js'],
            null,
            true
        );
		
		wp_enqueue_style(
			'codemirror-scrollbars-css',
			plugins_url('assets/codemirror-5.65.18/addon/scroll/simplescrollbars.css', __FILE__)
		);
		wp_enqueue_script(
			'codemirror-scrollbars-js',
			plugins_url('assets/codemirror-5.65.18/addon/scroll/simplescrollbars.js', __FILE__),
			['codemirror-js'],
			null,
			true
		);
		
		wp_enqueue_script(
			'codemirror-closebrackets-js',
			plugins_url('assets/codemirror-5.65.18/addon/edit/closebrackets.js', __FILE__),
			['codemirror-js'],
			null,
			true
		);
		
		wp_enqueue_script(
			'codemirror-closetag-js',
			plugins_url('assets/codemirror-5.65.18/addon/edit/closetag.js', __FILE__),
			['codemirror-js'],
			null,
			true
		);
		
		wp_enqueue_script(
			'codemirror-activeline-js',
			plugins_url('assets/codemirror-5.65.18/addon/selection/active-line.js', __FILE__),
			['codemirror-js'],
			null,
			true
		);
		
		wp_enqueue_style(
			'codemirror-fullscreen-css',
			plugins_url('assets/codemirror-5.65.18/addon/display/fullscreen.css', __FILE__)
		);
		wp_enqueue_script(
			'codemirror-fullscreen-js',
			plugins_url('assets/codemirror-5.65.18/addon/display/fullscreen.js', __FILE__),
			['codemirror-js'],
			null,
			true
		);
		
		wp_enqueue_style(
			'codemirror-color-css',
			plugins_url('assets/codemirror-colorpicker/dist/codemirror-colorpicker.css', __FILE__)
		);
		
		wp_enqueue_script(
			'codemirror-color-js',
			plugins_url('assets/codemirror-colorpicker/dist/codemirror-colorpicker.min.js', __FILE__),
			['codemirror-js'],
			null,
			true
		);
		
		wp_enqueue_script(
			'ss-manually-css-upload',
			plugin_dir_url(__FILE__) . 'assets/js/ss-manually-css-upload.js',
			['jquery'],
			'1.0.0',
			true
		);

		wp_localize_script('ss-manually-css-upload', 'ssManuallyCssUploadData', [
			'ajaxUrl' => admin_url('admin-ajax.php'),
			'nonce' => wp_create_nonce('ss-manually-css-upload-nonce'),
		]);
		
		wp_enqueue_script(
			'ss-video-lesson-popup',
			plugin_dir_url(__FILE__) . 'assets/js/ss-video-lesson-popup.js',
			['jquery'],
			'1.0.0',
			true
		);

        wp_enqueue_script(
            'ss-upload-script',
            plugin_dir_url(__FILE__) . 'assets/js/ss-upload.js',
            array('jquery'),
            null,
            true
        );

        $css_folder_path = WP_CONTENT_DIR . '/ss-css';
        $has_files = false;
        if (file_exists($css_folder_path)) {
            $files = array_diff(scandir($css_folder_path), array('.', '..'));
            foreach ($files as $file) {
                if (pathinfo($file, PATHINFO_EXTENSION) === 'css') {
                    $has_files = true;
                    break;
                }
            }
        }

        wp_localize_script('ss-upload-script', 'ssUploadData', array(
            'ajaxUrl' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('ss_upload_nonce'),
			'hasFiles' => $has_files,
        ));
    }
}
add_action('admin_enqueue_scripts', 'ss_enqueue_admin_styles');

function ss_create_css_folder() {
    $css_folder_path = WP_CONTENT_DIR . '/ss-css';
    $json_file_path = $css_folder_path . '/ss-active-css.json';

    if (!file_exists($css_folder_path)) {
        wp_mkdir_p($css_folder_path);
    }

    if (!file_exists($json_file_path)) {
        file_put_contents($json_file_path, json_encode([]));
    }
}
register_activation_hook(__FILE__, 'ss_create_css_folder');

function ss_files_upload_page() {
    ?>
    
<div class="ss-main-wrap">

	<div class="ss-menu-wrap">
		<div class="ss-menu-logo">
			<h2>
				<span class="color-accent-2">Преображатор</span>
				<span class="color-accent-1">Мемберлюкса</span>
			</h2>
		</div>

		<div class="ss-menu-links">
			<div class="ss-menu-download-style-link-wrap">
				<a target="_blank" rel="noopener" href="https://memberlux.online/ss-download-super-style-mbl">Библиотека дополнений</a>
			</div>

			<div class="ss-menu-support-link-wrap">
				<a target="_blank" rel="noopener" href="https://memberlux.online/tg-super-style-mbl">Телеграм-чат</a>
			</div>

			<div class="ss-menu-author-link-wrap">
				<a target="_blank" rel="noopener" href="https://memberlux.online/tg-igor-lokhman">Написать Игорю</a>
			</div>
			
			<div class="ss-menu-lesson-link-wrap">
				<a class="ss-lesson-button">Урок</a>
			</div>
		</div>
	</div>

	<div class="ss-wrap ss-wrap-files-upload-page">

        <div class="ss-upload-wrap">
            <div class="ss-select-and-upload-wrap">
                <h2>Импортируйте дополнения</h2>
                <p class="ss-desc-upload">Перетащите сюда файлы с вашими супер-стилями или скриптами и нажмите кнопку <strong>«Запустить преображатор»</strong>. Готово :)</p>
				<p class="ss-desc-upload">Ещё нет своих стилей и скриптов? Начните с <strong>Библиотеки дополнений</strong>.</p>

                <div class="ss-upload-area-with-message-wrap">
                    <div class="ss-upload-area-wrap"></div>

                    <div class="ss-status-upload-out">
                        <div class="ss-status-upload-out-icon"></div>
                        <div class="ss-status-upload-out-title">Кликните здесь или перетащите сюда файлы</div>
                        <div class="ss-status-upload-out-subtitle">(только форматы <span class="ss-upload-type-file color-accent-2">*.css</span> и <span class="ss-upload-type-file color-accent-1">*.js</span>)</div>
                    </div>

                    <div class="ss-status-upload-in">
                        <div class="ss-status-upload-in-icon"></div>
                        <div class="ss-status-upload-in-title">Отпустите мышку</div>
                        <div class="ss-status-upload-in-subtitle">После этого активируется кнопка запуска</div>
                    </div>
                </div>

                <div class="ss-upload-buttons-wrap">

					<div class="ss-auto-create-file-wrap">
						<button class="ss-upload-button" id="ss-upload-button" disabled>Запустить преображатор</button>
						<button class="ss-reset-upload-button" id="ss-reset-upload-button">Сбросить</button>
					 </div>


					<div class="ss-manually-create-empty-file-wrap">
						<button class="ss-manually-create-empty-file" id="ss-manually-create-empty-file">Шаблонизатор (создать файл)</button>
					</div>
					 
                </div>

                <div id="ss-select-upload-status" style="display: none;">
                    <p>Будет подключено файлов: <span class="count-selected-files"></span></p>
                </div>

            </div>
        </div>

        <div class="ss-no-files-massege-wrap">
			<div class="ss-no-files-massege">
				<p>Здесь появятся ваши дополнения. Пока пусто. Начните с <a class="ss-king-kit-link" target="_blank" rel="noopener" href="https://memberlux.online/ss-download-super-style-mbl">Библиотеки дополнений</a>
				</p>
			</div>
		</div>

        <div class="ss-table-connected-files-wrap">
		
            <div class="ss-title-and-buttons-section">

                <div class="ss-table-title-wrap">
                    <h2>Установленные стили и скрипты</h2>
					<div id="ss-expand-collapse-button">
						<span class="fi fi-rr-caret-quare-up"></span>
					</div>
                </div>
				
				<div id="ss-preloader-content-mini" style="display: none;">
					<img src="<?php echo plugins_url('assets/icons/ss-preloader.svg', __FILE__); ?>" alt="Загрузка...">
				</div>

				<div class="ss-table-buttons-wrap">
					<button type="button" id="ss-download-all-files-button">Скачать все файлы</button>
					<button type="button" id="ss-delete-all-files-button">Удалить все файлы</button>
				</div>
			
			</div>

			<div class="ss-table-and-list-files-and-active-files-wrap">

				<div class="ss-active-files-from-all-wrap">
					<p>Активных дополнений:
						<span class="ss-active-files"></span> из
						<span class="ss-all-installed-files"></span>
					</p>
				</div>

				<div class="ss-table-header-and-list-files-wrap">
						
					<div class="ss-all-files-wrap">

						<input type="checkbox" id="ss-check-all-files" value="" class="ss-check-all-files">

						<div class="ss-table-column-headers-section">
							<div class="ss-table-column-headers-wrap">
								<div class="ss-table-column-headers-row">
									<div class="ss-file-name-and-icon-wrap">
										<div class="ss-file-name-and-icon">
											<p id="ss-human-name-css">Название</p>
										</div>
									</div>

									<div class="ss-file-type-wrap">
										<p>Тип</p>
									</div>

									<div class="ss-author-name-and-image-wrap">
										<div class="ss-author-name-and-image">
											<p id="ss-author-human-name">Преображатор</p>
										</div>
									</div>
									
									<div class="ss-file-description-wrap">
										<p id="ss-human-description-css">Описание</p>
									</div>
									<div class="ss-file-settings">
										<p id="ss-file-settings-column-header">Действия</p>
									</div>
								</div>
							</div>
						</div>
					</div>

					<div class="ss-list-all-files-section">

					</div>

					<div class="ss-save-options-wrap">
						<button class="ss-save-options-button">Сохранить настройки</button>
					</div>

					<div class="ss-tip-for-page-navigation">
						<p><strong>Важно:</strong> Если поставили/убрали галочку и хотите перейти на другую страницу - сначала нажмите «Сохранить», иначе изменения не сохранятся.</p>
					</div>
					
				</div>
			</div>
        </div>

		<div class="ss-video-lesson-content-wrap" style="display: none;">
			<div class="ss-video-lesson-content-window">
				<div class="ss-video-player-wrap">
				<iframe src="https://player.vimeo.com/video/1065029241?h=af99324420&amp;badge=0&amp;autopause=0&amp;player_id=0&amp;app_id=58479" frameborder="0" allow="autoplay; fullscreen; picture-in-picture; clipboard-write; encrypted-media" style="position:absolute;top:0;left:0;width:100%;height:100%;" title="Преображатор Мемберлюкса - большой обзор"></iframe>
				</div>
				<script src="https://player.vimeo.com/api/player.js"></script>
			</div>
		</div>
		
        <div class="ss-hidden-upload-alert-wrap" style="display: none;">
            <div class="ss-hidden-upload-alert">
                <div class="ss-upload-alert-icon"></div>
                <div class="ss-upload-alert-title">
                    <h2>Выберите вариант</h2>
                </div>
                <div class="ss-upload-alert-subtitle">
                    <p>Некоторые из выбранных файлов уже установлены. Если нажмёте «Исключить совпадения», то существующие файлы отсеятся из выборки, и при повторном запуске Преображатор установит только новые файлы. Если нажмёте «Загрузить все файлы», то Преображатор перезапишет совпадающие файлы.</p>
                </div>
                <div class="ss-upload-alert-buttons-wrap">
                    <button class="ss-no-upload-button">Исключить совпадения</button>
                    <button class="ss-yes-upload-button">Загрузить все файлы</button>
                </div>
            </div>
        </div>
		
        <div class="ss-hidden-delete-all-alert-wrap" style="display: none;">
            <div class="ss-hidden-delete-all-alert">
                <div class="ss-delete-alert-icon"></div>
                <div class="ss-delete-alert-title">
                    <h2>Точно уверены?</h2>
                </div>
                <div class="ss-delete-alert-subtitle">
                    <p>Если продолжите, то в вашей школе удалятся абсолютно все файлы стилей и скриптов, которые вы установили в Преображаторе. Убедитесь, что вы заранее скачали все важные файлы на свой компьютер. Уверены, что хотите удалить их все?</p>
                </div>
                <div class="ss-delete-alert-buttons-wrap">
                    <button class="ss-no-delete-all-button">Не удалять</button>
                    <button class="ss-yes-delete-all-button">Да, удалить все файлы</button>
                </div>
            </div>
        </div>
		
        <div class="ss-hidden-delete-single-alert-wrap" style="display: none;">
            <div class="ss-hidden-delete-single-alert">
                <div class="ss-delete-alert-icon"></div>
                <div class="ss-delete-alert-title">
                    <h2>Точно уверены?</h2>
                </div>
                <div class="ss-delete-alert-subtitle">
                    <p>Если продолжите, то в вашей школе удалится один выбранный файл, который вы установили в Преображаторе. Убедитесь, что вы скачали резервную копию на свой компьютер. Уверены, что хотите удалить один выбранный файл?</p>
                </div>
                <div class="ss-delete-alert-buttons-wrap">
                    <button class="ss-no-delete-single-button">Не удалять</button>
                    <button class="ss-yes-delete-single-button">Да, удалить этот файл</button>
                </div>
            </div>
        </div>

        <div id="ss-preloader" style="display: none;">
            <div id="ss-preloader-content">
                <img src="<?php echo plugins_url('assets/icons/ss-preloader.svg', __FILE__); ?>" alt="Загрузка...">
            </div>
        </div>

    </div>

	<div class="ss-footer-wrap">
		<p class="ss-plugin-title">Преображатор Мемберлюкса<span class="ss-version"> (версия 1.0)</span></p>
		<p>© Игорь Лохман, 2025. Все права, надеюсь, защищены</p>
		<p class="ss-footer-links"><a class="ss-king-kit-link" target="_blank" rel="noopener" href="https://memberlux.online/redirect-king-kit">Царский набор рубрик</a>
		<a class="ss-space-kit-link" target="_blank" rel="noopener" href="https://memberlux.online/redirect-space-kit">Космический набор материалов</a></p>
	</div>

	<div class="ss-switch-theme ss-light-theme">
		<span class="fi fi-rr-moon"></span>
	</div>

</div>
    <?php
}

function ss_get_existing_files() {
    check_ajax_referer('ss_upload_nonce', 'nonce');
    $css_folder_path = WP_CONTENT_DIR . '/ss-css';
    $files = array();

    if (file_exists($css_folder_path)) {
        $files = array_values(array_diff(scandir($css_folder_path), array('.', '..')));
    }

    wp_send_json_success($files);
}
add_action('wp_ajax_ss_get_existing_files', 'ss_get_existing_files');

function ss_upload_files() {
    check_ajax_referer('ss_upload_nonce', 'nonce');
    $css_folder_path = WP_CONTENT_DIR . '/ss-css';

    if (!file_exists($css_folder_path)) {
        wp_mkdir_p($css_folder_path);
    }

    $uploaded_files = array();
    $errors = array();

    foreach ($_FILES['files']['tmp_name'] as $index => $tmp_name) {
        $file_name = sanitize_file_name($_FILES['files']['name'][$index]);
        $file_path = $css_folder_path . '/' . $file_name;

        if (move_uploaded_file($tmp_name, $file_path)) {
            $uploaded_files[] = $file_name;
        } else {
            $errors[] = "Не удалось загрузить файл: $file_name";
        }
    }

    if (!empty($errors)) {
        wp_send_json_error(array('message' => 'Некоторые файлы не удалось загрузить.', 'errors' => $errors));
    }

    wp_send_json_success(array('uploaded_files' => $uploaded_files));
}
add_action('wp_ajax_ss_upload_files', 'ss_upload_files');

add_action('wp_ajax_ss_save_active_css', 'ss_save_active_css');
function ss_save_active_css() {
    if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'ss_upload_nonce')) {
        wp_send_json_error(['message' => 'Ошибка проверки nonce.']);
    }

    if (!isset($_POST['activeFiles'])) {
        wp_send_json_error(['message' => 'Данные activeFiles отсутствуют.']);
    }

    $active_files = json_decode(stripslashes($_POST['activeFiles']), true);

    if (!is_array($active_files)) {
        wp_send_json_error(['message' => 'Некорректный формат данных activeFiles.']);
    }

	// Логирование для отладки (временно)
    error_log('Сохраняемые файлы: ' . print_r($active_files, true));

    $css_folder_path = WP_CONTENT_DIR . '/ss-css';
    $json_file_path = $css_folder_path . '/ss-active-css.json';

    if (file_put_contents($json_file_path, json_encode($active_files))) {
        wp_send_json_success(['message' => 'Активированные файлы сохранены.']);
    } else {
        wp_send_json_error(['message' => 'Ошибка при записи в файл.']);
    }
}

add_action('wp', function() {
    ob_start(function($buffer) {
        $css_js_folder_path = WP_CONTENT_DIR . '/ss-css';
        $css_js_folder_url = content_url('ss-css');
        $json_file_path = $css_js_folder_path . '/ss-active-css.json';

        if (file_exists($json_file_path)) {
            $active_files = json_decode(file_get_contents($json_file_path), true);
            if (is_array($active_files) && !empty($active_files)) {
                $styles_and_scripts = '';

                foreach ($active_files as $file) {
                    $file_path = $css_js_folder_path . '/' . $file;
                    $file_url = $css_js_folder_url . '/' . $file;
                    $ext = pathinfo($file, PATHINFO_EXTENSION);

                    if ($ext === 'css' && file_exists($file_path)) {
                        $styles_and_scripts .= sprintf(
                            '<link rel="stylesheet" id="ss-css-%s" href="%s" media="all" />' . "\n",
                            esc_attr(pathinfo($file, PATHINFO_FILENAME)),
                            esc_url($file_url)
                        );
                    }

                    if ($ext === 'js' && file_exists($file_path)) {
                        $styles_and_scripts .= sprintf(
                            '<script type="text/javascript" id="ss-js-%s" src="%s"></script>' . "\n",
                            esc_attr(pathinfo($file, PATHINFO_FILENAME)),
                            esc_url($file_url)
                        );
                    }
                }

                if (!empty($styles_and_scripts)) {
                    $styles_and_scripts = "\n<!-- -->\n" 
                            . $styles_and_scripts 
                            . "<!-- -->\n";
                    $buffer = str_replace('</head>', $styles_and_scripts . '</head>', $buffer);
                }
            }
        }

        return $buffer;
    });
});

add_action('shutdown', function() {
    if (ob_get_length()) {
        ob_end_flush();
    }
});

function ss_get_files_meta() {
    check_ajax_referer('ss_upload_nonce', 'nonce');

    if (!isset($_POST['files'])) {
        wp_send_json_error(['message' => 'Список файлов не указан']);
    }

    $files = json_decode(stripslashes($_POST['files']), true);
    if (!is_array($files)) {
        wp_send_json_error(['message' => 'Некорректный формат данных']);
    }

    $result = [];
    foreach ($files as $file) {
        if ($file === 'ss-active-css.json') continue;
        $file_path = WP_CONTENT_DIR . '/ss-css/' . sanitize_text_field($file);
        if (!file_exists($file_path)) continue;
        $css_content = file_get_contents($file_path);
        preg_match('/--human-name-css\s*:\s*(["\'])([^"\']+)\1;/', $css_content, $nameMatches);
        preg_match('/--human-description-css\s*:\s*(["\'])([^"\']+)\1;/', $css_content, $descMatches);
        preg_match('/--human-author-css\s*:\s*(["\'])([^"\']+)\1;/', $css_content, $authorMatches);
        preg_match('/--human-author-image-css\s*:\s*(["\'])([^"\']+)\1;/', $css_content, $authorImageMatches);

        $result[$file] = [
            'humanName'        => $nameMatches[2] ?? null,
            'humanDescription' => $descMatches[2] ?? null,
            'humanAuthor'      => $authorMatches[2] ?? null,
            'humanAuthorImage' => $authorImageMatches[2] ?? null,
        ];
    }

    wp_send_json_success($result);
}
add_action('wp_ajax_ss_get_files_meta', 'ss_get_files_meta');

// Добавляем favicon только на тех админ-страницах, где ?page=super-style

function ss_add_favicon_to_plugin_pages() {
	// Проверяем, что в URL есть параметр page и он начинается с "super-style"
    if (
        isset($_GET['page']) &&
        strncmp($_GET['page'], 'super-style', 11) === 0
    ) {
        // Генерируем правильный URL до favicon.svg внутри плагина
        $favicon_url = plugins_url( 'assets/icons/favicon.svg', __FILE__ );
        echo '<link rel="icon" href="' . esc_url( $favicon_url ) . '" type="image/svg+xml" />';
    }
}
add_action( 'admin_head', 'ss_add_favicon_to_plugin_pages' );

function ss_custom_menu_icon_style() {
    ?>
    <style>
		
		/* нижний отступ пункта меню */
		
		#adminmenu li.toplevel_page_super-style {
			margin-bottom: 10px;
		}
	
        /* Стили для иконки главного пункта меню */
		
        #toplevel_page_super-style .wp-menu-image img,
		.toplevel_page_super-style .wp-menu-image img {
            width: 21px;
			height: 21px;
			margin-top: -4px;
			margin-left: 2px;
			opacity: 1;
			padding: 9px 0 0 !important;
			max-width: none;
			max-height: none;
        }
		
		/* Цвет стрелки - при активной главной странице плагина */
		/* Делаем её цветом фона страниц плагина */
		
		#adminmenu li.toplevel_page_super-style.current a.toplevel_page_super-style:after {
			border-right-color: #F6F8FA!important;
		}
		
		#toplevel_page_super-style a.toplevel_page_super-style:focus .wp-menu-image img {
			opacity: 1;
		}
		
		#toplevel_page_super-style a {
			color: #ffffff;
        }
		
		#adminmenu li.current a.toplevel_page_super-style {
			background: #078cdf;
			color: #ffffff;
		}
		
		#adminmenu li.current a.toplevel_page_super-style .wp-menu-image img {
			opacity: 1;
		}
		
		#adminmenu li.toplevel_page_super-style a {
			background: #078cdf;
			transition: background .1s linear;
		}
		
		#adminmenu li.toplevel_page_super-style a:hover {
			background: #0792E9;
			transition: background .1s linear;
		}

		#adminmenu li.toplevel_page_super-style a:focus {
			background: #078cdf;
			transition: background .1s linear;
		}
		
		#adminmenu a.toplevel_page_super-style:hover,
		#adminmenu li.toplevel_page_super-style>a.menu-top:focus {
			box-shadow: none;
			color: #ffffff;
		}
		
    </style>
    <?php
}
add_action('admin_head', 'ss_custom_menu_icon_style');