document.addEventListener('DOMContentLoaded', function () {
    const deleteButton = document.getElementById('ss-delete-all-files-button');
    const alertWrap = document.querySelector('.ss-hidden-delete-all-alert-wrap');
    const noDeleteButton = document.querySelector('.ss-no-delete-all-button');
    const yesDeleteButton = document.querySelector('.ss-yes-delete-all-button');
    const preloader = document.getElementById('ss-preloader');

    const fadeIn = (element, duration = 300) => {
        element.style.opacity = 0;
        element.style.display = 'flex';
        let opacity = 0;

        const interval = 10;
        const increment = interval / duration;

        const animation = setInterval(() => {
            opacity += increment;
            element.style.opacity = opacity;

            if (opacity >= 1) {
                clearInterval(animation);
            }
        }, interval);
    };

    const fadeOut = (element, duration = 300) => {
        let opacity = 1;

        const interval = 10;
        const decrement = interval / duration;

        const animation = setInterval(() => {
            opacity -= decrement;
            element.style.opacity = opacity;

            if (opacity <= 0) {
                clearInterval(animation);
                element.style.display = 'none';
            }
        }, interval);
    };

    if (deleteButton) {
        deleteButton.addEventListener('click', function () {
            fadeIn(alertWrap);
        });
    }

    if (noDeleteButton) {
        noDeleteButton.addEventListener('click', function () {
            fadeOut(alertWrap);
        });
    }

    if (yesDeleteButton) {
        yesDeleteButton.addEventListener('click', function () {
            fadeOut(alertWrap, 300);

            setTimeout(() => {

                preloader.style.display = 'flex';

                const data = new URLSearchParams();
                data.append('action', 'ss_delete_all_css_files');
                data.append('nonce', ssDeletePluginData.nonce);

                fetch(ssDeletePluginData.ajaxUrl, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                    },
                    body: data.toString(),
                })
                    .then(response => response.json())
                    .then(data => {
                        preloader.style.display = 'none';
                        if (data.success) {
                            location.reload();
                        } else {
                            alert('Ошибка: ' + data.message);
                        }
                    })
                    .catch(error => {
                        preloader.style.display = 'none';
                        console.error('Ошибка AJAX-запроса:', error);
                        alert('Произошла ошибка при удалении файлов.');
                    });
            }, 300);
        });
    }
});