document.addEventListener('DOMContentLoaded', function () {
    const downloadButton = document.getElementById('ss-download-all-files-button');
    const preloader = document.getElementById('ss-preloader');

    if (downloadButton) {
        downloadButton.addEventListener('click', function () {

            preloader.style.display = 'flex';

            const data = new URLSearchParams();
            data.append('action', 'ss_download_all_css_files');
            data.append('nonce', ssExportPluginData.nonce);

            fetch(ssExportPluginData.ajaxUrl, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: data.toString(),
            })
                .then(response => response.json())
                .then(data => {
					console.log('AJAX response data:', data);
                    if (data.success && data.data.zip_url) {
                        const zipUrl = data.data.zip_url;
                        console.log('zip_url:', zipUrl);

                        preloader.style.display = 'none';

						const fileName = zipUrl.split('/').pop();

                        const tempLink = document.createElement('a');
                        tempLink.href = zipUrl;
                        tempLink.download = fileName;
                        document.body.appendChild(tempLink);
                        tempLink.click();
                        document.body.removeChild(tempLink);
                    } else {
                        preloader.style.display = 'none';
						console.error('Error from server response:', data);
                        alert('Произошла ошибка при создании архива.');
                    }
                })
                .catch(error => {
                    preloader.style.display = 'none';
                    console.error('Ошибка AJAX-запроса:', error);
                    alert('Произошла ошибка при выполнении запроса.');
                });
        });
    }
});