jQuery(document).ready(function ($) {
    const fadeIn = (element, duration = 300) => {
        element.style.opacity = 0;
        element.style.display = 'flex';
        let opacity = 0;

        const interval = 10;
        const increment = interval / duration;

        const animation = setInterval(() => {
            opacity += increment;
            element.style.opacity = opacity;

            if (opacity >= 1) {
                clearInterval(animation);
            }
        }, interval);
    };

    const fadeOut = (element, duration = 300) => {
        let opacity = 1;

        const interval = 10;
        const decrement = interval / duration;

        const animation = setInterval(() => {
            opacity -= decrement;
            element.style.opacity = opacity;

            if (opacity <= 0) {
                clearInterval(animation);
                element.style.display = 'none';
            }
        }, interval);
    };

    $(document).on("click", ".ss-file-delete", function () {
        const fileRow = $(this).closest(".ss-single-file-wrap");
		const fileName = fileRow.data("file-name");

        $(".ss-yes-delete-single-button").data("file-name", fileName);

        const alertWrap = document.querySelector(".ss-hidden-delete-single-alert-wrap");
        fadeIn(alertWrap);
    });

    $(document).on("click", ".ss-no-delete-single-button", function () {
        const alertWrap = document.querySelector(".ss-hidden-delete-single-alert-wrap");
        fadeOut(alertWrap);
    });

    $(document).on("click", ".ss-yes-delete-single-button", function () {
        const fileName = $(this).data("file-name");

        const alertWrap = document.querySelector(".ss-hidden-delete-single-alert-wrap");
        fadeOut(alertWrap);

        $("#ss-preloader").css("display", "flex");

        $.ajax({
            url: ssDeleteSinglePluginData.ajaxUrl,
            type: "POST",
            data: {
                action: "ss_delete_single_css_file",
                fileName: fileName,
                nonce: ssDeleteSinglePluginData.nonce,
            },
            success: function (response) {
                if (response.success) {
                    location.reload();
                } else {
                    alert("Ошибка при удалении файла: " + response.data.message);
                    $("#ss-preloader").css("display", "none");
                }
            },
            error: function () {
                alert("Не удалось связаться с сервером.");
                $("#ss-preloader").css("display", "none");
            },
        });
    });
});