jQuery(document).ready(function ($) {
    $(".ss-list-all-files-section").on("click", ".ss-file-download", function (event) {
		event.preventDefault();
		event.stopPropagation();
		
        const fileRow = $(this).closest(".ss-single-file-wrap");
		const fileName = fileRow.data("file-name");
		
		console.log("Клик по файлу:", fileName);

		if (!fileName) {
            alert("Ошибка: оригинальное имя файла не найдено.");
            return;
        }

        $.ajax({
            url: ssExportSinglePluginData.ajaxUrl,
            method: "POST",
            data: {
                action: "ss_download_single_css_file",
                file_name: fileName,
                nonce: ssExportSinglePluginData.nonce
            },
            success: function (response) {
				console.log("Ответ сервера:", response);
                if (response.success) {
                    const downloadLink = document.createElement("a");
                    downloadLink.href = response.data.file_url;
					downloadLink.download = fileName;
                    downloadLink.click();
                } else {
                    alert("Ошибка: " + response.data.message);
                }
            },
            error: function () {
				console.error("Ошибка AJAX-запроса:", error);
                alert("Произошла ошибка при попытке скачать файл.");
            }
        });
    });
});