<?php

function render_ss_manually_create_css_form() {
    ?>
    <div class="ss-manually-create-wrap" style="display: none;">
        <div class="ss-manually-create-window">
            <div class="ss-manually-create-close-wrap">
                <span class="ss-manually-create-close-icon"></span>
            </div>
			
			<div class="ss-manually-title-and-form-wrap">
			
				<div class="ss-manually-create-title">
					<h2>Создать шаблон дополнения</h2>
				</div>
				
				<form class="ss-manually-create-form" id="ss-manually-create-form" method="POST" action="">
					<div class="ss-manually-input-css-name-wrap">
						<p>Имя файла на латинице + расширение <span class="ss-manually-highlight ss-manually-file-type-css">.css</span> или <span class="ss-manually-highlight ss-manually-file-type-js">.js</span></p>
						<input type="text" id="ss-css-name" name="ss-css-name" placeholder="Имя файла" required title="Это обязательное поле">
					</div>
					<div class="ss-manually-input-css-name-exists" style="display: none;">
						<p>Такой файл уже существует. Задайте другое имя.</p>
					</div>
					<div class="ss-manually-input-css-name-wrong" style="display: none;">
						<p>Имя должно быть на латинице и оканчиваться на .css или .js</p>
					</div>
					<div class="ss-manually-input-css-title-wrap">
						<p>Название файла в таблице (например, <span class="ss-manually-highlight">«Мой супер-стиль»</span>)</p>
						<input type="text" id="ss-css-title" name="ss-css-title" placeholder="Название файла">
					</div>
					<div class="ss-manually-input-css-author-name-wrap">
						<p>Имя автора файла</p>
						<input type="text" id="ss-css-author-name" name="ss-css-author-name" placeholder="Имя автора">
					</div>
					<div class="ss-manually-input-css-author-image-wrap">
						<p>Выберите и загрузите аватар автора <span class="ss-manually-highlight">(формат 1:1</span>)</p>
						
						<div class="ss-manually-url-and-button-wrap">
							<input type="text" id="ss-css-author-image" name="ss-css-author-image" placeholder="Путь до аватара">
							<button type="button" class="ss-open-media-upload-image-button">Выбрать</button>
						</div>
						
					</div>
					<div class="ss-manually-input-css-description-wrap">
						<p>Описание файла в таблице</p>
						<input type="text" id="ss-css-description" name="ss-css-description" placeholder="Описание файла">
					</div>
					<div class="ss-manually-create-buttons-wrap">
						<button type="button" id="ss-manually-cancel-button">Отменить</button>
						<button type="submit" id="ss-manually-create-button">Создать файл</button>
					</div>
				</form>
				
			</div>
			
        </div>
    </div>
    <?php
}
add_action('admin_footer', 'render_ss_manually_create_css_form');

add_action('wp_ajax_ss_create_css_file', 'ss_create_css_file');
function ss_create_css_file() {
    check_ajax_referer('ss-manually-css-upload-nonce', 'security');

    $css_name = sanitize_file_name($_POST['css_name']);
    $css_title = sanitize_text_field($_POST['css_title']);
    $css_author = sanitize_text_field($_POST['css_author']);
    $css_image = esc_url_raw($_POST['css_image']);
    $css_description = sanitize_text_field($_POST['css_description']);
	$file_extension = pathinfo($css_name, PATHINFO_EXTENSION);
	
	$allowed_extensions = ['css', 'js'];
    if (!in_array($file_extension, $allowed_extensions)) {
        wp_send_json_error(['message' => 'Неверное расширение файла. Допустимые расширения: .css, .js']);
    }

    $css_dir = WP_CONTENT_DIR . '/ss-css/';
    $css_file = $css_dir . $css_name;

    if (file_exists($css_file)) {
        wp_send_json_success(['exists' => true]);
    }

    if (!is_dir($css_dir)) {
        mkdir($css_dir, 0755, true);
    }

	$css_content = <<<CSS
/* Задайте своё человеческое название файла между '' */
/* --human-name-css: '{$css_title}'; */

/* Укажите имя автора между '' */
/* --human-author-css: '{$css_author}'; */

/* Задайте путь до аватара автора между "" */
/* --human-author-image-css: "{$css_image}"; */

/* Задайте своё человеческое описание файла между '' */
/* --human-description-css: '{$css_description}'; */
CSS;

    file_put_contents($css_file, $css_content);

    wp_send_json_success(['exists' => false]);
}

add_action('admin_enqueue_scripts', function () {
    wp_enqueue_media();
});